package com.alibaba.schedulerx.worker.master.handler;

import com.alibaba.schedulerx.common.domain.InstanceStatus;
import com.alibaba.schedulerx.common.domain.JobInstanceInfo;
import com.alibaba.schedulerx.common.util.ConfigUtil;
import com.alibaba.schedulerx.common.util.IdUtil;
import com.alibaba.schedulerx.protocol.Worker.WorkerReportJobInstanceStatusRequest;
import com.alibaba.schedulerx.worker.SchedulerxWorker;
import com.alibaba.schedulerx.worker.domain.WorkerConstants;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import com.alibaba.schedulerx.worker.logcollector.ClientLoggerMessage;
import com.alibaba.schedulerx.worker.logcollector.LogCollector;
import com.alibaba.schedulerx.worker.logcollector.LogCollectorFactory;
import com.alibaba.schedulerx.worker.master.TaskMaster;
import com.alibaba.schedulerx.worker.processor.ProcessResult;

import org.apache.commons.lang.StringUtils;

/**
 *
 * @author zhaibian
 * @version $Id: CommonUpdateInstanceStatusHandler.java, v 0.1 2019年02月28日 19:38 zhaibian Exp $
 */
public class CommonUpdateInstanceStatusHandler extends UpdateInstanceStatusHandler {

    private LogCollector logCollector = LogCollectorFactory.get();
    private static final Logger LOGGER = LogFactory.getLogger(CommonUpdateInstanceStatusHandler.class);

    CommonUpdateInstanceStatusHandler(TaskMaster taskMaster, JobInstanceInfo jobInstanceInfo) {
        super(taskMaster, jobInstanceInfo);
    }

    @Override
    public void handle(long serialNum, InstanceStatus instanceStatus, String result) throws Exception {
        String uniqueId = IdUtil.getUniqueIdWithoutTask(jobInstanceInfo.getJobId(), jobInstanceInfo.getJobInstanceId());
        if (!taskMaster.getInstanceStatus().equals(instanceStatus)) {
            taskMaster.setInstanceStatus(instanceStatus);
            if (instanceStatus.isFinish()) {
                 ProcessResult postResult = taskMaster.postFinish(jobInstanceInfo.getJobInstanceId());
                 if (postResult != null) {
                     if (instanceStatus.equals(InstanceStatus.SUCCESS) && postResult.getStatus().equals(InstanceStatus.FAILED)) {
                         instanceStatus = InstanceStatus.FAILED;
                     }
                     if (postResult.getResult() != null) {
                         result = postResult.getResult();
                     }
                 }

                //report job instance status with at-least-once-delivery
                WorkerReportJobInstanceStatusRequest.Builder builder = WorkerReportJobInstanceStatusRequest
                        .newBuilder()
                        .setJobId(jobInstanceInfo.getJobId())
                        .setJobInstanceId(jobInstanceInfo.getJobInstanceId())
                        .setStatus(instanceStatus.getValue())
                        .setGroupId(jobInstanceInfo.getGroupId());

                if (result != null) {
                    builder.setResult(result);
                }

                String progress = taskMaster.getJobInstanceProgress();
                if (!StringUtils.isEmpty(progress)) {
                    builder.setProgress(progress);
                }
                SchedulerxWorker.AtLeastDeliveryRoutingActor.tell(builder.build(), null);
                LOGGER.info("report jobInstance={}, status={} to AtLeastDeliveryRoutingActor", jobInstanceInfo.getJobInstanceId(),
                    instanceStatus);

                //destory containers and taskMaster
                boolean enableShareContainerPool = ConfigUtil.getWorkerConfig().getBoolean(WorkerConstants.SHARE_CONTAINER_POOL, false);
                if (!enableShareContainerPool) {
                    taskMaster.destroyContainerPool();
                }
                masterPool.get(jobInstanceInfo.getJobInstanceId()).stop();
                masterPool.remove(jobInstanceInfo.getJobInstanceId());
                logCollector.collect(uniqueId, ClientLoggerMessage.appendMessage(ClientLoggerMessage.INSTANCE_FINISH,
                        instanceStatus.getEnDesc()));
                LOGGER.info("uniqueId: {} is finished, remove from MasterPool.", uniqueId);
            }
        }

    }
}
