package com.alibaba.schedulerx.worker.master;

import java.io.IOException;
import java.util.List;

import com.alibaba.schedulerx.common.domain.JobInstanceInfo;
import com.alibaba.schedulerx.worker.domain.WorkerConstants;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import com.alibaba.schedulerx.worker.master.persistence.H2FilePersistence;
import com.alibaba.schedulerx.worker.util.SystemManagementUtil;

import akka.actor.ActorContext;
import com.google.protobuf.ByteString;
import org.apache.commons.collections.CollectionUtils;

/**
 *
 * @author xiaomeng.hxm
 */
public class BatchTaskMaster extends GridTaskMaster {
    private static final Logger LOGGER = LogFactory.getLogger(BatchTaskMaster.class);

    public BatchTaskMaster(JobInstanceInfo jobInstanceInfo, ActorContext actorContext) throws Exception {
        super(jobInstanceInfo, actorContext);
        this.taskPersistence = H2FilePersistence.getInstance();
        this.taskPersistence.initTable();
    }

    @Override
    public boolean map(List<ByteString> taskList, String taskName) throws Exception {
        if (CollectionUtils.isEmpty(taskList)) {
            LOGGER.warn("map taskList is empty, taskName:{}", taskName);
            return false;
        }
        LOGGER.info("map taskList, jobInstanceId={}, taskName:{}, taskList size:{}", jobInstanceInfo.getJobInstanceId(),
                taskName, taskList.size());
        float usedSpacePercent = SystemManagementUtil.getUserDiskSpacePercent();
        if (usedSpacePercent > WorkerConstants.USER_SPACE_PERCENT_MAX) {
            throw new IOException("used space beyond " + WorkerConstants.USER_SPACE_PERCENT_MAX * 100 + "%!");
        }
        return super.map(taskList, taskName);
    }
}
