package com.alibaba.schedulerx.worker.discovery;

import java.util.List;

import akka.actor.ActorSelection;
import akka.actor.ActorSystem;

/**
 * Created by yanxun on 2018/5/23.
 *
 * @author yanxun
 * @date 2018/05/23
 */
public interface ServerDiscovery {
    /**
     * start sync process for keeping cache up to date
     * @throws Exception exceptions thrown in start process
     */
    void start(String namespace, String namespaceSource, String groupId) throws Exception;

    /**
     * stop sync process for releasing resources
     * @throws Exception exceptions thrown in stop process
     */
    void stop() throws Exception;
    
    void reset(ActorSystem actorSystem);

    /**
     * get active server ip and port
     * @return active server's ip:port
     */
    String getActiveServerAddr();

    List<ActorSelection> getStandbyServerHeatbeatActors();

    /**
     * get active server's actor path
     * @return active server's actor path
     */
//    ActorSelection getActiveServerActor();

    /**
     * get active heartbeat's actor path
     * @return active heartbeat actor
     */
    ActorSelection getActiveHeartBeatActor();

    ActorSelection getInstanceStatusRouter();

    ActorSelection getMapMasterRouter();

    ActorSelection getTaskStatusRouter();
}
