package com.alibaba.schedulerx.worker.discovery;

import java.util.List;

import com.alibaba.schedulerx.worker.domain.WorkerConstants;

import com.google.common.collect.Lists;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;

/**
 *
 * @author xiaomeng.hxm
 */
public class DefaultGroupDiscovery implements GroupDiscovery {

    @Override
    public String getGroupId(Configuration conf) {
        return conf.getString(WorkerConstants.GROUP_ID);
    }

    @Override
    public List<String> getGroupIdSet(Configuration conf) throws Exception {
        List<String> groupIdSet = Lists.newArrayList();
        // 优先-D
        String groupIdProperty = System.getProperty(WorkerConstants.WORKER_GROUPID);
        if (StringUtils.isBlank(groupIdProperty)) {
            groupIdProperty = System.getenv(WorkerConstants.WORKER_GROUPID.replace(".", "_"));
        }
        if (StringUtils.isNotBlank(groupIdProperty)) {
            conf.setProperty(WorkerConstants.GROUP_ID, groupIdProperty);
        }
        String[] groupIds = conf.getStringArray(WorkerConstants.GROUP_ID);
        for (String groupId : groupIds) {
            groupIdSet.add(groupId.trim());
        }
        return groupIdSet;
    }

}
