package com.alibaba.schedulerx.worker.discovery;

import java.util.List;

import com.alibaba.schedulerx.common.util.IpUtil;
import com.alibaba.schedulerx.common.util.JsonUtil;
import com.alibaba.schedulerx.worker.domain.WorkerConstants;

import com.google.common.collect.Lists;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import org.apache.commons.configuration.Configuration;

/**
 *
 * @author xiaomeng.hxm
 */
public class ArmoryGroupDiscovery implements GroupDiscovery {

    @Override
    public String getGroupId(Configuration conf) throws UnirestException {
        String groupName = null;
        String localIp = conf.getString(WorkerConstants.HOSTNAME, IpUtil.getIPV4Address());
        HttpResponse<JsonNode> response = Unirest.get("http://api.sh.gns.alibaba-inc.com/gns/armory/query?ip=" + localIp).asJson();
        ArmoryResult result =  JsonUtil.fromJson(response.getBody().getObject().toString(), ArmoryResult.class);
        if (result.isSuccess() && result.getData() != null) {
            groupName = result.getData().getNodegroup();
        }
        return groupName;
    }

    @Override
    public List<String> getGroupIdSet(Configuration conf) throws Exception {
        return Lists.newArrayList(getGroupId(conf));
    }

}
