package com.alibaba.schedulerx.worker.container;

import java.util.Map;

import com.alibaba.schedulerx.worker.domain.JobContext;

import com.google.common.collect.Maps;

/**
 *
 * @author xiaomeng.hxm
 */
public abstract class ContainerPool {

    private Map<String, Container> containerMap = Maps.newConcurrentMap();

    public Map<String, Container> getContainerMap() {
        return containerMap;
    }

    public void setContainerMap(Map<String, Container> containerMap) {
        this.containerMap = containerMap;
    }

    public Container get(String uniqueId) {
        return containerMap.get(uniqueId);
    }

    public void put(String uniqueId, Container container) {
        containerMap.put(uniqueId, container);
    }

    public void remove(String uniqueId) {
        containerMap.remove(uniqueId);
    }

    public boolean contain(String uniqueId) {
        return containerMap.containsKey(uniqueId);
    }

    /**
     * submit task container
     * @param jobId job id
     * @param jobInstanceId instance identification
     * @param taskId task identification
     * @param container running container
     * @param consumerSize running container service max capacity
     */
    public abstract void submit(long jobId, long jobInstanceId, long taskId, Container container, int consumerSize);

    /**
     * destroy pool by jobInstance
     * @param jobInstanceId instance identification
     */
    public abstract boolean destroyByInstance(long jobInstanceId);

    public abstract void setContext(JobContext jobContext);

    public abstract JobContext getContext();

    public abstract void removeContext();

}
