package com.alibaba.schedulerx.worker.actor;

import java.util.ArrayList;
import java.util.List;

import com.alibaba.schedulerx.worker.actor.routing.InstanceRoutingLogic;

import akka.actor.ActorRef;
import akka.actor.Props;
import akka.actor.Terminated;
import akka.actor.UntypedActor;
import akka.routing.ActorRefRoutee;
import akka.routing.Routee;
import akka.routing.Router;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/**
 *
 * @author xiaomeng.hxm
 */
public class TaskRouter extends UntypedActor {
    private Router router;
    private static final Logger LOGGER = LogManager.getLogger();

    public TaskRouter(int size) {
        List<Routee> routees = new ArrayList<Routee>();
        for (int i = 0; i < size; i++) {
            ActorRef actor = getContext().actorOf(Props.create(TaskActor.class)
                    .withDispatcher("akka.actor.thread-dispatcher-task"));
            getContext().watch(actor);
            routees.add(new ActorRefRoutee(actor));
        }
        router = new Router(new InstanceRoutingLogic(), routees);
    }

    public static Props props(int size) {
        return Props.create(TaskRouter.class, size);
    }

    @Override
    public void onReceive(Object obj) throws Exception {
        if (obj instanceof Terminated) {
            router = router.removeRoutee(((Terminated) obj).actor());
            ActorRef r = getContext().actorOf(Props.create(TaskActor.class));
            getContext().watch(r);
            router = router.addRoutee(new ActorRefRoutee(r));
        } else {
            router.route(obj, getSender());
        }
    }
}
