package com.alibaba.schedulerx.worker.actor;

import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

import akka.dispatch.ExecutionContexts;
import com.google.common.collect.Maps;
import scala.concurrent.ExecutionContext;

public enum FutureExecutorPool {
    
    INSTANCE;
    
    private Map<String, ExecutionContext> executorPool = Maps.newConcurrentMap(); 
    
    public ExecutionContext get(final String name) {
        if (!executorPool.containsKey(name)) {
            ThreadPoolExecutor executor = new ThreadPoolExecutor(16, 16,
                    0, TimeUnit.MILLISECONDS,
                    new LinkedBlockingQueue<Runnable>(),
                    new ThreadFactory() {
                        int index = 0;
                        @Override
                        public Thread newThread(Runnable r) {
                            index++;
                            return new Thread(r, "Schedulerx-FutureExecutor-" + name + "-" + index);
                        }
            });
            executorPool.put(name, ExecutionContexts.fromExecutor(executor));
        }
        return executorPool.get(name);
    }
    
    public void addExecutor(String name, ThreadPoolExecutor executor) {
        executorPool.put(name, ExecutionContexts.fromExecutor(executor));
    }
   
}
