package com.alibaba.schedulerx.worker.actor;

import java.util.ArrayList;
import java.util.List;

import com.alibaba.schedulerx.worker.actor.routing.InstanceRoutingLogic;

import akka.actor.ActorRef;
import akka.actor.Props;
import akka.actor.Terminated;
import akka.actor.UntypedActor;
import akka.routing.ActorRefRoutee;
import akka.routing.Routee;
import akka.routing.Router;

/**
 *
 * @author xiaomeng.hxm
 */
public class ContainerRoutingActor extends UntypedActor {

    private Router router;

    public ContainerRoutingActor(int size) {
//        this.size = size;
//        for (int i = 0; i < size; i++) {
//            ActorRef containerActor = getContext().actorOf(Props.create(ContainerActor.class)
//                    .withDispatcher("akka.actor.thread-dispatcher-container"));
//            actors.add(containerActor);
//        }
        List<Routee> routees = new ArrayList<Routee>();
        for (int i = 0; i < size; i++) {
            ActorRef actor = getContext().actorOf(Props.create(ContainerActor.class)
                    .withDispatcher("akka.actor.thread-dispatcher-container"));
            getContext().watch(actor);
            routees.add(new ActorRefRoutee(actor));
        }
        router = new Router(new InstanceRoutingLogic(), routees);
    }

    public static Props props(int size) {
        return Props.create(ContainerRoutingActor.class, size);
    }

    @Override
    public void onReceive(Object obj) throws Exception {
        if (obj instanceof Terminated) {
            router = router.removeRoutee(((Terminated) obj).actor());
            ActorRef r = getContext().actorOf(Props.create(ContainerActor.class));
            getContext().watch(r);
            router = router.addRoutee(new ActorRefRoutee(r));
        } else {
//            long jobInstanceId = (long) ReflectionUtil.invokeMethod(obj, "getJobInstanceId");
//            LOGGER.debug("receive " + obj.getClass().getSimpleName() + ", jobInstanceId=" + jobInstanceId);
            router.route(obj, getSender());
        }
    }
}
