package com.alibaba.schedulerx.sdk.http;

import java.security.cert.X509Certificate;
import java.util.Map;

import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

import com.alibaba.schedulerx.common.domain.JSONResult;
import com.alibaba.schedulerx.common.domain.ResponseCode;
import com.alibaba.schedulerx.common.domain.enums.ResponseCodeEnum;
import com.alibaba.schedulerx.common.exception.BaseBizException;
import com.alibaba.schedulerx.common.sdk.common.SchedulerXResult;
import com.alibaba.schedulerx.common.sdk.request.BaseRequest;
import com.alibaba.schedulerx.common.sdk.response.BaseResponse;
import com.alibaba.schedulerx.common.util.ExceptionUtil;
import com.alibaba.schedulerx.common.util.JsonUtil;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.Unirest;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

/**
 * http请求发送
 *
 * @author 陆昆
 * @create 2018-12-16 下午12:48
 **/
public class HttpClientUtil {
    private static final Logger logger = LogFactory.getLogger("openapi");

    // https请求
    static {
        try {
            TrustManager[] trustAllCerts = new TrustManager[] {new X509TrustManager() {
                public java.security.cert.X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sslcontext = SSLContext.getInstance("SSL");
            sslcontext.init(null, trustAllCerts, new java.security.SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sslcontext.getSocketFactory());
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext);
            CloseableHttpClient httpclient = HttpClients.custom().setSSLSocketFactory(sslsf).build();
            Unirest.setHttpClient(httpclient);
        } catch (Throwable e) {
            logger.error("SSL init error.", e);
        }
    }

    // 请求发送与解析
    public static <T extends BaseResponse> SchedulerXResult<T> getResponse(BaseRequest<T> request, String domain,
                                                                           Map<String, String> headers) {

        SchedulerXResult<T> result = new SchedulerXResult<>();
        try {
            String url = domain + request.getUrlPath();
            // 构造openapi请求
            HttpResponse<JsonNode> jsonResponse = Unirest.post(url).headers(headers).fields(request.getParameterMap()).asJson();
            if (jsonResponse != null) {
                JSONResult jsonResult = JsonUtil.fromJson(jsonResponse.getBody().toString(), JSONResult.class);
                result = new SchedulerXResult<T>(jsonResult);
                if (jsonResult.isSuccess()) {
                    // 成功的解析数据
                    T resp = JsonUtil.fromJson(JsonUtil.toJson(jsonResult.getData()), request.getResponseClass());
                    result.setData(resp);
                    logger.info("getResponse success response: " + jsonResult.getData());
                } else {
                    logger.error("getResponse fail response: " + jsonResult);
                }
            } else {
                throw new BaseBizException(ResponseCodeEnum.SYSTEM_ERROR.getCode(), "response is null.");
            }
        } catch (Throwable e) {
            logger.error("getResponse error, request: " + request, e);
            result.setCode(ResponseCode.OPEN_API_REQUEST_ERROR);
            result.setMessage(ExceptionUtil.getMessage(e));
        }
        return result;
    }
}
