/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.master;

import akka.actor.ActorContext;
import com.alibaba.schedulerx.common.domain.InstanceStatus;
import com.alibaba.schedulerx.common.domain.JobInstanceData;
import com.alibaba.schedulerx.common.domain.JobInstanceInfo;
import com.alibaba.schedulerx.common.domain.MapTaskXAttrs;
import com.alibaba.schedulerx.common.domain.TaskStatus;
import com.alibaba.schedulerx.common.util.IdUtil;
import com.alibaba.schedulerx.common.util.JsonUtil;
import com.alibaba.schedulerx.protocol.Common;
import com.alibaba.schedulerx.protocol.Server;
import com.alibaba.schedulerx.protocol.Worker;
import com.alibaba.schedulerx.shade.com.google.common.collect.Maps;
import com.alibaba.schedulerx.shade.com.google.common.collect.Sets;
import com.alibaba.schedulerx.shade.com.google.protobuf.ByteString;
import com.alibaba.schedulerx.worker.discovery.ServerDiscovery;
import com.alibaba.schedulerx.worker.discovery.ServerDiscoveryFactory;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import com.alibaba.schedulerx.worker.master.handler.UpdateInstanceStatusHandler;
import com.alibaba.schedulerx.worker.master.handler.UpdateInstanceStatusHandlerFactory;
import com.alibaba.schedulerx.worker.processor.ProcessResult;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public abstract class TaskMaster {
    private final ActorContext actorContext;
    protected volatile InstanceStatus instanceStatus = InstanceStatus.RUNNING;
    protected Map<String, TaskStatus> taskStatusMap = Maps.newHashMap();
    protected AtomicLong taskIdGenerator = new AtomicLong(0L);
    private final String localContainerRouterPath;
    private final String localTaskRouterPath;
    private final String localInstanceRouterPath;
    protected final JobInstanceInfo jobInstanceInfo;
    protected final UpdateInstanceStatusHandler statusHandler;
    protected volatile boolean killed = false;
    protected volatile boolean INITED = false;
    protected Set<String> aliveCheckWorkerSet = Sets.newConcurrentHashSet();
    protected final ServerDiscovery SERVER_DISCOVERY;
    protected AtomicLong serialNum = new AtomicLong(1L);
    private static final Logger LOGGER = LogFactory.getLogger(TaskMaster.class);

    public TaskMaster(JobInstanceInfo jobInstanceInfo, ActorContext actorContext) throws Exception {
        this.jobInstanceInfo = jobInstanceInfo;
        this.actorContext = actorContext;
        this.localInstanceRouterPath = actorContext.provider().getDefaultAddress().toString() + "/user/job_instance_routing";
        this.localContainerRouterPath = actorContext.provider().getDefaultAddress().toString() + "/user/container_routing";
        this.localTaskRouterPath = actorContext.provider().getDefaultAddress().toString() + "/user/task_routing";
        this.SERVER_DISCOVERY = ServerDiscoveryFactory.getDiscovery(jobInstanceInfo.getGroupId());
        this.aliveCheckWorkerSet.addAll(jobInstanceInfo.getAllWorkers());
        this.checkProcessor();
        this.statusHandler = UpdateInstanceStatusHandlerFactory.create(this, jobInstanceInfo);
    }

    public ActorContext getActorContext() {
        return this.actorContext;
    }

    public String getLocalJobInstanceRouterPath() {
        return this.localInstanceRouterPath;
    }

    public String getLocalContainerRouterPath() {
        return this.localContainerRouterPath;
    }

    public String getLocalTaskRouterPath() {
        return this.localTaskRouterPath;
    }

    public boolean isJobInstanceFinished() {
        boolean isFinish = true;
        for (TaskStatus status : this.taskStatusMap.values()) {
            if (status.isFinish()) continue;
            isFinish = false;
            break;
        }
        return isFinish;
    }

    public void updateTaskStatus(Worker.ContainerReportTaskStatusRequest request2) throws Exception {
        long jobId = request2.getJobId();
        long jobInstanceId = request2.getJobInstanceId();
        long taskId = request2.getTaskId();
        TaskStatus taskStatus = TaskStatus.parseValue(request2.getStatus());
        String uniqueId = IdUtil.getUniqueId(jobId, jobInstanceId, taskId);
        this.taskStatusMap.put(uniqueId, taskStatus);
        InstanceStatus newStatus = InstanceStatus.UNKNOWN;
        if (this.taskStatusMap.size() > 0) {
            if (!this.isJobInstanceFinished()) {
                newStatus = InstanceStatus.RUNNING;
            } else {
                newStatus = InstanceStatus.SUCCESS;
                if (!newStatus.equals((Object)InstanceStatus.FAILED)) {
                    for (TaskStatus status : this.taskStatusMap.values()) {
                        if (!status.equals((Object)TaskStatus.FAILED)) continue;
                        newStatus = InstanceStatus.FAILED;
                        break;
                    }
                }
            }
        }
        this.updateNewInstanceStatus(request2.getSerialNum(), jobInstanceId, newStatus, request2.getResult());
    }

    public void batchUpdateTaskStatus(Worker.ContainerBatchReportTaskStatuesRequest request2) throws Exception {
        for (Worker.TaskStatusInfo taskStatusInfo : request2.getTaskStatuesList()) {
            Worker.ContainerReportTaskStatusRequest.Builder builder = Worker.ContainerReportTaskStatusRequest.newBuilder().setJobId(request2.getJobId()).setJobInstanceId(request2.getJobInstanceId()).setTaskId(taskStatusInfo.getTaskId()).setWorkerAddr(request2.getWorkerAddr()).setWorkerId(request2.getWorkerId()).setStatus(taskStatusInfo.getStatus());
            if (taskStatusInfo.hasResult()) {
                builder.setResult(taskStatusInfo.getResult());
            }
            if (taskStatusInfo.hasTaskName()) {
                builder.setTaskName(taskStatusInfo.getTaskName());
            }
            if (request2.hasSerialNum()) {
                builder.setSerialNum(request2.getSerialNum());
            }
            this.updateTaskStatus(builder.build());
        }
    }

    public void killInstance(String reason) {
        this.killed = true;
    }

    public abstract void destroyContainerPool();

    public void killTask(String uniqueId, String workerId, String workerAddr) {
    }

    protected void init() {
        if (this.INITED) {
            return;
        }
        this.INITED = true;
    }

    public void retryTasks(List<Server.RetryTaskEntity> taskEntities) {
    }

    public abstract void submitInstance(JobInstanceInfo var1) throws Exception;

    protected long aquireTaskId() {
        return this.taskIdGenerator.getAndIncrement();
    }

    public String getJobInstanceProgress() {
        return "0.5";
    }

    public void updateNewInstanceStatus(long serialNum, InstanceStatus newStatus, String result2) {
        this.updateNewInstanceStatus(serialNum, this.jobInstanceInfo.getJobInstanceId(), newStatus, result2);
    }

    protected synchronized void updateNewInstanceStatus(long serialNum, long jobInstanceId, InstanceStatus newStatus, String result2) {
        try {
            this.statusHandler.handle(serialNum, newStatus, result2);
        }
        catch (Exception e) {
            LOGGER.error("update jobInstanceId={} serialNum={}, status={} failed", jobInstanceId, serialNum, newStatus.getValue(), e);
        }
    }

    public void stop() {
    }

    public void clear() {
        this.taskStatusMap.clear();
        this.taskIdGenerator.set(0L);
        this.instanceStatus = InstanceStatus.RUNNING;
        this.aliveCheckWorkerSet.clear();
        this.destroyContainerPool();
    }

    public ProcessResult postFinish(long jobInstanceId) {
        return null;
    }

    protected Worker.MasterStartContainerRequest convert2StartContainerRequest(JobInstanceInfo jobInstanceInfo, long taskId) {
        return this.convert2StartContainerRequest(jobInstanceInfo, taskId, null, null);
    }

    protected Worker.MasterStartContainerRequest convert2StartContainerRequest(JobInstanceInfo jobInstanceInfo, long taskId, String taskName, ByteString taskBody) {
        return this.convert2StartContainerRequest(jobInstanceInfo, taskId, taskName, taskBody, false);
    }

    protected Worker.MasterStartContainerRequest convert2StartContainerRequest(JobInstanceInfo jobInstanceInfo, long taskId, String taskName, ByteString taskBody, boolean failover) {
        Worker.MasterStartContainerRequest.Builder builder = Worker.MasterStartContainerRequest.newBuilder();
        builder.setJobId(jobInstanceInfo.getJobId());
        builder.setJobInstanceId(jobInstanceInfo.getJobInstanceId());
        builder.setTaskId(taskId);
        builder.setUser(jobInstanceInfo.getUser());
        builder.setJobType(jobInstanceInfo.getJobType());
        builder.setContent(jobInstanceInfo.getContent());
        builder.setScheduleTime(jobInstanceInfo.getScheduleTime().getMillis());
        builder.setDataTime(jobInstanceInfo.getDataTime().getMillis());
        builder.setParameters(jobInstanceInfo.getParameters());
        builder.setInstanceParameters(jobInstanceInfo.getInstanceParameters());
        builder.setInstanceMasterAkkaPath(this.getLocalTaskRouterPath());
        builder.setGroupId(jobInstanceInfo.getGroupId());
        builder.setMaxAttempt(jobInstanceInfo.getMaxAttempt());
        builder.setAttempt(jobInstanceInfo.getAttempt());
        if (jobInstanceInfo.getUpstreamData() != null && !jobInstanceInfo.getUpstreamData().isEmpty()) {
            for (JobInstanceData jobInstanceData : jobInstanceInfo.getUpstreamData()) {
                Common.UpstreamData upstreamData = Common.UpstreamData.newBuilder().setJobName(jobInstanceData.getJobName()).setData(jobInstanceData.getData()).build();
                builder.addUpstreamData(upstreamData);
            }
        }
        if (jobInstanceInfo.getXattrs() != null && !jobInstanceInfo.getXattrs().isEmpty()) {
            MapTaskXAttrs xAttrs = JsonUtil.fromJson(jobInstanceInfo.getXattrs(), MapTaskXAttrs.class);
            builder.setConsumerNum(xAttrs.getConsumerSize());
            builder.setTaskMaxAttempt(xAttrs.getTaskMaxAttempt());
            builder.setTaskAttemptInterval(xAttrs.getTaskAttemptInterval());
        }
        if (taskName != null) {
            builder.setTaskName(taskName);
        }
        if (taskBody != null) {
            builder.setTask(taskBody);
        }
        if (failover) {
            builder.setFailover(true);
        }
        if (jobInstanceInfo.getWfInstanceId() != null) {
            builder.setWfInstanceId(jobInstanceInfo.getWfInstanceId());
        }
        builder.setSerialNum(this.getSerialNum());
        builder.setExecuteMode(jobInstanceInfo.getExecuteMode());
        if (jobInstanceInfo.getJobName() != null) {
            builder.setJobName(jobInstanceInfo.getJobName());
        }
        return builder.build();
    }

    public InstanceStatus getInstanceStatus() {
        return this.instanceStatus;
    }

    public void setInstanceStatus(InstanceStatus instanceStatus) {
        this.instanceStatus = instanceStatus;
    }

    public boolean isKilled() {
        return this.killed;
    }

    public JobInstanceInfo getJobInstanceInfo() {
        return this.jobInstanceInfo;
    }

    public Set<String> getAliveCheckWorkerSet() {
        return this.aliveCheckWorkerSet;
    }

    public boolean isInited() {
        return this.INITED;
    }

    public long getSerialNum() {
        return this.serialNum.get();
    }

    public long aquireSerialNum() {
        return this.serialNum.incrementAndGet();
    }

    protected void checkProcessor() throws Exception {
    }
}

