/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.discovery;

import com.alibaba.schedulerx.common.util.ConfigUtil;
import com.alibaba.schedulerx.common.util.ReflectionUtil;
import com.alibaba.schedulerx.shade.com.google.common.collect.Maps;
import com.alibaba.schedulerx.worker.SchedulerxWorker;
import com.alibaba.schedulerx.worker.discovery.DefaultServerDiscovery;
import com.alibaba.schedulerx.worker.discovery.ServerDiscovery;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import java.util.Map;

public class ServerDiscoveryFactory {
    private static Map<String, ServerDiscovery> SERVER_DiSCOVERY_MAP = Maps.newConcurrentMap();
    private static final Logger LOGGER = LogFactory.getLogger(ServerDiscoveryFactory.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServerDiscovery getDiscovery(String groupId) {
        if (!SERVER_DiSCOVERY_MAP.containsKey(groupId)) {
            Map<String, ServerDiscovery> map2 = SERVER_DiSCOVERY_MAP;
            synchronized (map2) {
                if (!SERVER_DiSCOVERY_MAP.containsKey(groupId)) {
                    String className = ConfigUtil.getWorkerConfig().getString("worker.server.discovery", DefaultServerDiscovery.class.getName());
                    try {
                        ServerDiscovery serverDiscovery = (ServerDiscovery)ReflectionUtil.getInstanceByClassName(className, SchedulerxWorker.CUSTOMER_CLASS_LOADER);
                        SERVER_DiSCOVERY_MAP.put(groupId, serverDiscovery);
                    }
                    catch (Throwable e) {
                        LOGGER.error("", e);
                    }
                }
            }
        }
        return SERVER_DiSCOVERY_MAP.get(groupId);
    }
}

