/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.worker.batch;

import com.alibaba.schedulerx.shade.com.google.common.collect.Lists;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class ReqQueue<T> {
    private long jobInstanceId;
    private int capacity;
    private static final Logger LOGGER = LogFactory.getLogger(ReqQueue.class);
    private BlockingQueue<T> requests;

    public ReqQueue(long jobInstanceId, int capacity) {
        this.jobInstanceId = jobInstanceId;
        this.capacity = capacity;
    }

    public void init() {
        this.requests = new LinkedBlockingQueue<T>(this.capacity);
    }

    public void submitRequest(T request2) throws Exception {
        try {
            if (request2 != null) {
                this.requests.put(request2);
            }
        }
        catch (Throwable e) {
            LOGGER.error("add task status request to queue error, jobInstanceId:{}", this.jobInstanceId, e);
            throw e;
        }
    }

    public List<T> retrieveRequests(int batchSize) {
        Object request2;
        LinkedList res = Lists.newLinkedList();
        for (int i = 0; i < batchSize && (request2 = this.requests.poll()) != null; ++i) {
            res.add(request2);
        }
        return res;
    }

    public void clear() {
        this.requests.clear();
    }

    public int size() {
        return this.requests.size();
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }
}

