/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.json.zip;

import com.alibaba.schedulerx.shade.org.json.zip.BitInputStream;
import com.alibaba.schedulerx.shade.org.json.zip.BitWriter;
import java.io.IOException;
import java.io.OutputStream;

public class BitOutputStream
implements BitWriter {
    private long nrBits = 0L;
    private OutputStream out;
    private int unwritten;
    private int vacant = 8;

    public BitOutputStream(OutputStream out) {
        this.out = out;
    }

    public long nrBits() {
        return this.nrBits;
    }

    public void one() throws IOException {
        this.write(1, 1);
    }

    public void pad(int factor) throws IOException {
        int padding2 = factor - (int)(this.nrBits % (long)factor);
        int excess = padding2 & 7;
        if (excess > 0) {
            this.write(0, excess);
            padding2 -= excess;
        }
        while (padding2 > 0) {
            this.write(0, 8);
            padding2 -= 8;
        }
        this.out.flush();
    }

    public void write(int bits2, int width) throws IOException {
        if (bits2 == 0 && width == 0) {
            return;
        }
        if (width <= 0 || width > 32) {
            throw new IOException("Bad write width.");
        }
        while (width > 0) {
            int actual = width;
            if (actual > this.vacant) {
                actual = this.vacant;
            }
            this.unwritten |= (bits2 >>> width - actual & BitInputStream.mask[actual]) << this.vacant - actual;
            width -= actual;
            this.nrBits += (long)actual;
            this.vacant -= actual;
            if (this.vacant != 0) continue;
            this.out.write(this.unwritten);
            this.unwritten = 0;
            this.vacant = 8;
        }
    }

    public void zero() throws IOException {
        this.write(0, 1);
    }
}

