/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.json.zip;

import com.alibaba.schedulerx.shade.org.json.zip.BitReader;
import java.io.IOException;
import java.io.InputStream;

public class BitInputStream
implements BitReader {
    static final int[] mask = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255};
    private int available = 0;
    private int unread = 0;
    private InputStream in;
    private long nrBits = 0L;

    public BitInputStream(InputStream in2) {
        this.in = in2;
    }

    public BitInputStream(InputStream in2, int firstByte) {
        this.in = in2;
        this.unread = firstByte;
        this.available = 8;
    }

    public boolean bit() throws IOException {
        return this.read(1) != 0;
    }

    public long nrBits() {
        return this.nrBits;
    }

    public boolean pad(int factor) throws IOException {
        int padding2 = factor - (int)(this.nrBits % (long)factor);
        boolean result2 = true;
        for (int i = 0; i < padding2; ++i) {
            if (!this.bit()) continue;
            result2 = false;
        }
        return result2;
    }

    public int read(int width) throws IOException {
        if (width == 0) {
            return 0;
        }
        if (width < 0 || width > 32) {
            throw new IOException("Bad read width.");
        }
        int result2 = 0;
        while (width > 0) {
            int take2;
            if (this.available == 0) {
                this.unread = this.in.read();
                if (this.unread < 0) {
                    throw new IOException("Attempt to read past end.");
                }
                this.available = 8;
            }
            if ((take2 = width) > this.available) {
                take2 = this.available;
            }
            result2 |= (this.unread >>> this.available - take2 & mask[take2]) << width - take2;
            this.nrBits += (long)take2;
            this.available -= take2;
            width -= take2;
        }
        return result2;
    }
}

