/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.jboss.netty.channel.local;

import com.alibaba.schedulerx.shade.org.jboss.netty.channel.AbstractChannelSink;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.Channel;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.ChannelEvent;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.ChannelException;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.ChannelFuture;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.ChannelPipeline;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.ChannelState;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.ChannelStateEvent;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.Channels;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.MessageEvent;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.local.DefaultLocalChannel;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.local.DefaultLocalServerChannel;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.local.LocalAddress;
import com.alibaba.schedulerx.shade.org.jboss.netty.channel.local.LocalChannelRegistry;
import java.net.SocketAddress;

final class LocalServerChannelSink
extends AbstractChannelSink {
    LocalServerChannelSink() {
    }

    public void eventSunk(ChannelPipeline pipeline, ChannelEvent e) throws Exception {
        Channel channel = e.getChannel();
        if (channel instanceof DefaultLocalServerChannel) {
            LocalServerChannelSink.handleServerChannel(e);
        } else if (channel instanceof DefaultLocalChannel) {
            LocalServerChannelSink.handleAcceptedChannel(e);
        }
    }

    private static void handleServerChannel(ChannelEvent e) {
        if (!(e instanceof ChannelStateEvent)) {
            return;
        }
        ChannelStateEvent event = (ChannelStateEvent)e;
        DefaultLocalServerChannel channel = (DefaultLocalServerChannel)event.getChannel();
        ChannelFuture future2 = event.getFuture();
        ChannelState state = event.getState();
        Object value2 = event.getValue();
        switch (state) {
            case OPEN: {
                if (!Boolean.FALSE.equals(value2)) break;
                LocalServerChannelSink.close(channel, future2);
                break;
            }
            case BOUND: {
                if (value2 != null) {
                    LocalServerChannelSink.bind(channel, future2, (LocalAddress)value2);
                    break;
                }
                LocalServerChannelSink.close(channel, future2);
            }
        }
    }

    private static void handleAcceptedChannel(ChannelEvent e) {
        if (e instanceof ChannelStateEvent) {
            ChannelStateEvent event = (ChannelStateEvent)e;
            DefaultLocalChannel channel = (DefaultLocalChannel)event.getChannel();
            ChannelFuture future2 = event.getFuture();
            ChannelState state = event.getState();
            Object value2 = event.getValue();
            switch (state) {
                case OPEN: {
                    if (!Boolean.FALSE.equals(value2)) break;
                    channel.closeNow(future2);
                    break;
                }
                case BOUND: 
                case CONNECTED: {
                    if (value2 != null) break;
                    channel.closeNow(future2);
                    break;
                }
                case INTEREST_OPS: {
                    future2.setSuccess();
                }
            }
        } else if (e instanceof MessageEvent) {
            MessageEvent event = (MessageEvent)e;
            DefaultLocalChannel channel = (DefaultLocalChannel)event.getChannel();
            boolean offered = channel.writeBuffer.offer(event);
            assert (offered);
            channel.flushWriteBuffer();
        }
    }

    private static void bind(DefaultLocalServerChannel channel, ChannelFuture future2, LocalAddress localAddress) {
        try {
            if (!LocalChannelRegistry.register(localAddress, channel)) {
                throw new ChannelException("address already in use: " + localAddress);
            }
            if (!channel.bound.compareAndSet(false, true)) {
                throw new ChannelException("already bound");
            }
            channel.localAddress = localAddress;
            future2.setSuccess();
            Channels.fireChannelBound(channel, (SocketAddress)localAddress);
        }
        catch (Throwable t) {
            LocalChannelRegistry.unregister(localAddress);
            future2.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
    }

    private static void close(DefaultLocalServerChannel channel, ChannelFuture future2) {
        try {
            if (channel.setClosed()) {
                future2.setSuccess();
                LocalAddress localAddress = channel.localAddress;
                if (channel.bound.compareAndSet(true, false)) {
                    channel.localAddress = null;
                    LocalChannelRegistry.unregister(localAddress);
                    Channels.fireChannelUnbound(channel);
                }
                Channels.fireChannelClosed(channel);
            } else {
                future2.setSuccess();
            }
        }
        catch (Throwable t) {
            future2.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
    }
}

