/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.util;

import com.alibaba.schedulerx.shade.org.h2.tools.SimpleResultSet;
import com.alibaba.schedulerx.shade.org.h2.util.New;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class MergedResultSet {
    private final ArrayList<Map<ColumnInfo, Object>> data = New.arrayList();
    private final ArrayList<ColumnInfo> columns = New.arrayList();

    public void add(ResultSet resultSet) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        if (n == 0) {
            return;
        }
        ColumnInfo[] columnInfoArray = new ColumnInfo[n];
        for (int i = 1; i <= n; ++i) {
            ColumnInfo columnInfo;
            columnInfoArray[i - 1] = columnInfo = new ColumnInfo(resultSetMetaData.getColumnName(i), resultSetMetaData.getColumnType(i), resultSetMetaData.getPrecision(i), resultSetMetaData.getScale(i));
            if (this.columns.contains(columnInfo)) continue;
            this.columns.add(columnInfo);
        }
        while (resultSet.next()) {
            if (n == 1) {
                this.data.add(Collections.singletonMap(columnInfoArray[0], resultSet.getObject(1)));
                continue;
            }
            HashMap<ColumnInfo, Object> hashMap = new HashMap<ColumnInfo, Object>();
            for (int i = 1; i <= n; ++i) {
                ColumnInfo columnInfo = columnInfoArray[i - 1];
                hashMap.put(columnInfo, resultSet.getObject(i));
            }
            this.data.add(hashMap);
        }
    }

    public SimpleResultSet getResult() {
        SimpleResultSet simpleResultSet = new SimpleResultSet();
        for (ColumnInfo object : this.columns) {
            simpleResultSet.addColumn(object.name, object.type, object.precision, object.scale);
        }
        for (Map map2 : this.data) {
            Object[] objectArray = new Object[this.columns.size()];
            for (Map.Entry entry : map2.entrySet()) {
                objectArray[this.columns.indexOf(entry.getKey())] = entry.getValue();
            }
            simpleResultSet.addRow(objectArray);
        }
        return simpleResultSet;
    }

    public String toString() {
        return this.columns + ": " + this.data.size();
    }

    private static final class ColumnInfo {
        final String name;
        final int type;
        final int precision;
        final int scale;

        ColumnInfo(String string2, int n, int n2, int n3) {
            this.name = string2;
            this.type = n;
            this.precision = n2;
            this.scale = n3;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            ColumnInfo columnInfo = (ColumnInfo)object;
            return this.name.equals(columnInfo.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

