/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.util;

import com.alibaba.schedulerx.shade.org.h2.api.CustomDataTypesHandler;
import com.alibaba.schedulerx.shade.org.h2.api.JavaObjectSerializer;
import com.alibaba.schedulerx.shade.org.h2.engine.SysProperties;
import com.alibaba.schedulerx.shade.org.h2.message.DbException;
import com.alibaba.schedulerx.shade.org.h2.store.DataHandler;
import com.alibaba.schedulerx.shade.org.h2.util.New;
import com.alibaba.schedulerx.shade.org.h2.util.StringUtils;
import com.alibaba.schedulerx.shade.org.h2.util.Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import javax.naming.Context;
import javax.sql.DataSource;

public class JdbcUtils {
    public static JavaObjectSerializer serializer;
    public static CustomDataTypesHandler customDataTypesHandler;
    private static final String[] DRIVERS;
    private static boolean allowAllClasses;
    private static HashSet<String> allowedClassNames;
    private static ArrayList<Utils.ClassFactory> userClassFactories;
    private static String[] allowedClassNamePrefixes;

    private JdbcUtils() {
    }

    public static void addClassFactory(Utils.ClassFactory classFactory) {
        JdbcUtils.getUserClassFactories().add(classFactory);
    }

    public static void removeClassFactory(Utils.ClassFactory classFactory) {
        JdbcUtils.getUserClassFactories().remove(classFactory);
    }

    private static ArrayList<Utils.ClassFactory> getUserClassFactories() {
        if (userClassFactories == null) {
            userClassFactories = new ArrayList();
        }
        return userClassFactories;
    }

    public static <Z> Class<Z> loadUserClass(String string2) {
        if (allowedClassNames == null) {
            String string3 = SysProperties.ALLOWED_CLASSES;
            ArrayList<String> object = New.arrayList();
            int n = 0;
            HashSet<String> hashSet = new HashSet<String>();
            for (String string4 : StringUtils.arraySplit(string3, ',', true)) {
                if (string4.equals("*")) {
                    n = 1;
                    continue;
                }
                if (string4.endsWith("*")) {
                    object.add(string4.substring(0, string4.length() - 1));
                    continue;
                }
                hashSet.add(string4);
            }
            allowedClassNamePrefixes = object.toArray(new String[0]);
            allowAllClasses = n;
            allowedClassNames = hashSet;
        }
        if (!allowAllClasses && !allowedClassNames.contains(string2)) {
            boolean bl = false;
            for (String string5 : allowedClassNamePrefixes) {
                if (!string2.startsWith(string5)) continue;
                bl = true;
            }
            if (!bl) {
                throw DbException.get(90134, string2);
            }
        }
        for (Utils.ClassFactory classFactory : JdbcUtils.getUserClassFactories()) {
            if (!classFactory.match(string2)) continue;
            try {
                Class<?> clazz = classFactory.loadClass(string2);
                if (clazz == null) continue;
                return clazz;
            }
            catch (Exception exception) {
                throw DbException.get(90086, exception, string2);
            }
        }
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                return Class.forName(string2, true, Thread.currentThread().getContextClassLoader());
            }
            catch (Exception exception) {
                throw DbException.get(90086, classNotFoundException, string2);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw DbException.get(90086, noClassDefFoundError, string2);
        }
        catch (Error error) {
            throw DbException.get(50000, error, string2);
        }
    }

    public static void closeSilently(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void closeSilently(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void closeSilently(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static Connection getConnection(String string2, String string3, String string4, String string5) throws SQLException {
        Properties properties = new Properties();
        if (string4 != null) {
            properties.setProperty("user", string4);
        }
        if (string5 != null) {
            properties.setProperty("password", string5);
        }
        return JdbcUtils.getConnection(string2, string3, properties);
    }

    public static Connection getConnection(String string2, String string3, Properties properties) throws SQLException {
        if (!StringUtils.isNullOrEmpty(string2)) {
            Class clazz = JdbcUtils.loadUserClass(string2);
            if (Driver.class.isAssignableFrom(clazz)) {
                try {
                    Driver driver = (Driver)clazz.newInstance();
                    return driver.connect(string3, properties);
                }
                catch (Exception exception) {
                    throw DbException.toSQLException(exception);
                }
            }
            if (Context.class.isAssignableFrom(clazz)) {
                try {
                    Context context = (Context)clazz.newInstance();
                    DataSource dataSource = (DataSource)context.lookup(string3);
                    String string4 = properties.getProperty("user");
                    String string5 = properties.getProperty("password");
                    if (StringUtils.isNullOrEmpty(string4) && StringUtils.isNullOrEmpty(string5)) {
                        return dataSource.getConnection();
                    }
                    return dataSource.getConnection(string4, string5);
                }
                catch (Exception exception) {
                    throw DbException.toSQLException(exception);
                }
            }
            return DriverManager.getConnection(string3, properties);
        }
        JdbcUtils.load(string3);
        return DriverManager.getConnection(string3, properties);
    }

    public static String getDriver(String string2) {
        if (string2.startsWith("jdbc:")) {
            string2 = string2.substring("jdbc:".length());
            for (int i = 0; i < DRIVERS.length; i += 2) {
                String string3 = DRIVERS[i];
                if (!string2.startsWith(string3)) continue;
                return DRIVERS[i + 1];
            }
        }
        return null;
    }

    public static void load(String string2) {
        String string3 = JdbcUtils.getDriver(string2);
        if (string3 != null) {
            JdbcUtils.loadUserClass(string3);
        }
    }

    public static byte[] serialize(Object object, DataHandler dataHandler) {
        try {
            JavaObjectSerializer javaObjectSerializer = null;
            if (dataHandler != null) {
                javaObjectSerializer = dataHandler.getJavaObjectSerializer();
            }
            if (javaObjectSerializer != null) {
                return javaObjectSerializer.serialize(object);
            }
            if (serializer != null) {
                return serializer.serialize(object);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            return byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            throw DbException.get(90026, throwable, throwable.toString());
        }
    }

    public static Object deserialize(byte[] byArray, DataHandler dataHandler) {
        try {
            ObjectInputStream objectInputStream;
            JavaObjectSerializer javaObjectSerializer = null;
            if (dataHandler != null) {
                javaObjectSerializer = dataHandler.getJavaObjectSerializer();
            }
            if (javaObjectSerializer != null) {
                return javaObjectSerializer.deserialize(byArray);
            }
            if (serializer != null) {
                return serializer.deserialize(byArray);
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            if (SysProperties.USE_THREAD_CONTEXT_CLASS_LOADER) {
                final ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                objectInputStream = new ObjectInputStream(byteArrayInputStream){

                    @Override
                    protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
                        try {
                            return Class.forName(objectStreamClass.getName(), true, classLoader);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            return super.resolveClass(objectStreamClass);
                        }
                    }
                };
            } else {
                objectInputStream = new ObjectInputStream(byteArrayInputStream);
            }
            return objectInputStream.readObject();
        }
        catch (Throwable throwable) {
            throw DbException.get(90027, throwable, throwable.toString());
        }
    }

    static {
        String string2;
        DRIVERS = new String[]{"h2:", "com.alibaba.schedulerx.shade.org.h2.Driver", "Cache:", "com.intersys.jdbc.CacheDriver", "daffodilDB://", "in.co.daffodil.db.rmi.RmiDaffodilDBDriver", "daffodil", "in.co.daffodil.db.jdbc.DaffodilDBDriver", "db2:", "com.ibm.db2.jcc.DB2Driver", "derby:net:", "org.apache.derby.jdbc.ClientDriver", "derby://", "org.apache.derby.jdbc.ClientDriver", "derby:", "org.apache.derby.jdbc.EmbeddedDriver", "FrontBase:", "com.frontbase.jdbc.FBJDriver", "firebirdsql:", "org.firebirdsql.jdbc.FBDriver", "hsqldb:", "org.hsqldb.jdbcDriver", "informix-sqli:", "com.informix.jdbc.IfxDriver", "jtds:", "net.sourceforge.jtds.jdbc.Driver", "microsoft:", "com.microsoft.jdbc.sqlserver.SQLServerDriver", "mimer:", "com.mimer.jdbc.Driver", "mysql:", "com.mysql.jdbc.Driver", "odbc:", "sun.jdbc.odbc.JdbcOdbcDriver", "oracle:", "oracle.jdbc.driver.OracleDriver", "pervasive:", "com.pervasive.jdbc.v2.Driver", "pointbase:micro:", "com.pointbase.me.jdbc.jdbcDriver", "pointbase:", "com.pointbase.jdbc.jdbcUniversalDriver", "postgresql:", "org.postgresql.Driver", "sybase:", "com.sybase.jdbc3.jdbc.SybDriver", "sqlserver:", "com.microsoft.sqlserver.jdbc.SQLServerDriver", "teradata:", "com.ncr.teradata.TeraDriver"};
        userClassFactories = new ArrayList();
        String string3 = SysProperties.JAVA_OBJECT_SERIALIZER;
        if (string3 != null) {
            try {
                serializer = (JavaObjectSerializer)JdbcUtils.loadUserClass(string3).newInstance();
            }
            catch (Exception exception) {
                throw DbException.convert(exception);
            }
        }
        if ((string2 = SysProperties.CUSTOM_DATA_TYPES_HANDLER) != null) {
            try {
                customDataTypesHandler = (CustomDataTypesHandler)JdbcUtils.loadUserClass(string2).newInstance();
            }
            catch (Exception exception) {
                throw DbException.convert(exception);
            }
        }
    }
}

