/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.jdbc;

import com.alibaba.schedulerx.shade.org.h2.command.CommandInterface;
import com.alibaba.schedulerx.shade.org.h2.engine.SessionInterface;
import com.alibaba.schedulerx.shade.org.h2.engine.SysProperties;
import com.alibaba.schedulerx.shade.org.h2.jdbc.JdbcBatchUpdateException;
import com.alibaba.schedulerx.shade.org.h2.jdbc.JdbcConnection;
import com.alibaba.schedulerx.shade.org.h2.jdbc.JdbcResultSet;
import com.alibaba.schedulerx.shade.org.h2.jdbc.JdbcStatementBackwardsCompat;
import com.alibaba.schedulerx.shade.org.h2.message.DbException;
import com.alibaba.schedulerx.shade.org.h2.message.TraceObject;
import com.alibaba.schedulerx.shade.org.h2.result.ResultInterface;
import com.alibaba.schedulerx.shade.org.h2.result.ResultWithGeneratedKeys;
import com.alibaba.schedulerx.shade.org.h2.tools.SimpleResultSet;
import com.alibaba.schedulerx.shade.org.h2.util.New;
import com.alibaba.schedulerx.shade.org.h2.util.ParserUtil;
import com.alibaba.schedulerx.shade.org.h2.util.StringUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;

public class JdbcStatement
extends TraceObject
implements Statement,
JdbcStatementBackwardsCompat {
    protected JdbcConnection conn;
    protected SessionInterface session;
    protected JdbcResultSet resultSet;
    protected int maxRows;
    protected int fetchSize = SysProperties.SERVER_RESULT_SET_FETCH_SIZE;
    protected int updateCount;
    protected JdbcResultSet generatedKeys;
    protected final int resultSetType;
    protected final int resultSetConcurrency;
    protected final boolean closedByResultSet;
    private volatile CommandInterface executingCommand;
    private int lastExecutedCommandType;
    private ArrayList<String> batchCommands;
    private boolean escapeProcessing = true;
    private volatile boolean cancelled;

    JdbcStatement(JdbcConnection jdbcConnection, int n, int n2, int n3, boolean bl) {
        this.conn = jdbcConnection;
        this.session = jdbcConnection.getSession();
        this.setTrace(this.session.getTrace(), 8, n);
        this.resultSetType = n2;
        this.resultSetConcurrency = n3;
        this.closedByResultSet = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery(String string2) throws SQLException {
        try {
            int n = JdbcStatement.getNextId(4);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("ResultSet", 4, n, "executeQuery(" + JdbcStatement.quote(string2) + ")");
            }
            SessionInterface sessionInterface = this.session;
            synchronized (sessionInterface) {
                ResultInterface resultInterface;
                this.checkClosed();
                this.closeOldResultSet();
                string2 = JdbcConnection.translateSQL(string2, this.escapeProcessing);
                CommandInterface commandInterface = this.conn.prepareCommand(string2, this.fetchSize);
                boolean bl = false;
                boolean bl2 = this.resultSetType != 1003;
                boolean bl3 = this.resultSetConcurrency == 1008;
                this.setExecutingStatement(commandInterface);
                try {
                    resultInterface = commandInterface.executeQuery(this.maxRows, bl2);
                    bl = resultInterface.isLazy();
                }
                finally {
                    if (!bl) {
                        this.setExecutingStatement(null);
                    }
                }
                if (!bl) {
                    commandInterface.close();
                }
                this.resultSet = new JdbcResultSet(this.conn, this, commandInterface, resultInterface, n, this.closedByResultSet, bl2, bl3);
            }
            return this.resultSet;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int executeUpdate(String string2) throws SQLException {
        try {
            this.debugCodeCall("executeUpdate", string2);
            return this.executeUpdateInternal(string2, false);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public long executeLargeUpdate(String string2) throws SQLException {
        try {
            this.debugCodeCall("executeLargeUpdate", string2);
            return this.executeUpdateInternal(string2, false);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeUpdateInternal(String string2, Object object) throws SQLException {
        this.checkClosedForWrite();
        try {
            this.closeOldResultSet();
            string2 = JdbcConnection.translateSQL(string2, this.escapeProcessing);
            CommandInterface commandInterface = this.conn.prepareCommand(string2, this.fetchSize);
            SessionInterface sessionInterface = this.session;
            synchronized (sessionInterface) {
                this.setExecutingStatement(commandInterface);
                try {
                    ResultWithGeneratedKeys resultWithGeneratedKeys = commandInterface.executeUpdate(this.conn.scopeGeneratedKeys() ? Boolean.valueOf(false) : object);
                    this.updateCount = resultWithGeneratedKeys.getUpdateCount();
                    ResultInterface resultInterface = resultWithGeneratedKeys.getGeneratedKeys();
                    if (resultInterface != null) {
                        int n = JdbcStatement.getNextId(4);
                        this.generatedKeys = new JdbcResultSet(this.conn, this, commandInterface, resultInterface, n, false, true, false);
                    }
                }
                finally {
                    this.setExecutingStatement(null);
                }
            }
            commandInterface.close();
            int n = this.updateCount;
            return n;
        }
        finally {
            this.afterWriting();
        }
    }

    @Override
    public boolean execute(String string2) throws SQLException {
        try {
            this.debugCodeCall("execute", string2);
            return this.executeInternal(string2, false);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeInternal(String string2, Object object) throws SQLException {
        int n = JdbcStatement.getNextId(4);
        this.checkClosedForWrite();
        try {
            boolean bl;
            this.closeOldResultSet();
            string2 = JdbcConnection.translateSQL(string2, this.escapeProcessing);
            CommandInterface commandInterface = this.conn.prepareCommand(string2, this.fetchSize);
            boolean bl2 = false;
            SessionInterface sessionInterface = this.session;
            synchronized (sessionInterface) {
                this.setExecutingStatement(commandInterface);
                try {
                    if (commandInterface.isQuery()) {
                        bl = true;
                        boolean bl3 = this.resultSetType != 1003;
                        boolean bl4 = this.resultSetConcurrency == 1008;
                        ResultInterface resultInterface = commandInterface.executeQuery(this.maxRows, bl3);
                        bl2 = resultInterface.isLazy();
                        this.resultSet = new JdbcResultSet(this.conn, this, commandInterface, resultInterface, n, this.closedByResultSet, bl3, bl4);
                    } else {
                        bl = false;
                        ResultWithGeneratedKeys resultWithGeneratedKeys = commandInterface.executeUpdate(this.conn.scopeGeneratedKeys() ? Boolean.valueOf(false) : object);
                        this.updateCount = resultWithGeneratedKeys.getUpdateCount();
                        ResultInterface resultInterface = resultWithGeneratedKeys.getGeneratedKeys();
                        if (resultInterface != null) {
                            this.generatedKeys = new JdbcResultSet(this.conn, this, commandInterface, resultInterface, n, false, true, false);
                        }
                    }
                }
                finally {
                    if (!bl2) {
                        this.setExecutingStatement(null);
                    }
                }
            }
            if (!bl2) {
                commandInterface.close();
            }
            boolean bl5 = bl;
            return bl5;
        }
        finally {
            this.afterWriting();
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        try {
            this.checkClosed();
            if (this.resultSet != null) {
                int n = this.resultSet.getTraceId();
                this.debugCodeAssign("ResultSet", 4, n, "getResultSet()");
            } else {
                this.debugCodeCall("getResultSet");
            }
            return this.resultSet;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int getUpdateCount() throws SQLException {
        try {
            this.debugCodeCall("getUpdateCount");
            this.checkClosed();
            return this.updateCount;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        try {
            this.debugCodeCall("getLargeUpdateCount");
            this.checkClosed();
            return this.updateCount;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        try {
            this.debugCodeCall("close");
            SessionInterface sessionInterface = this.session;
            synchronized (sessionInterface) {
                this.closeOldResultSet();
                if (this.conn != null) {
                    this.conn = null;
                }
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public Connection getConnection() {
        this.debugCodeCall("getConnection");
        return this.conn;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            this.debugCodeCall("getWarnings");
            this.checkClosed();
            return null;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            this.debugCodeCall("clearWarnings");
            this.checkClosed();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setCursorName(String string2) throws SQLException {
        try {
            this.debugCodeCall("setCursorName", string2);
            this.checkClosed();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        try {
            this.debugCodeCall("setFetchDirection", n);
            this.checkClosed();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        try {
            this.debugCodeCall("getFetchDirection");
            this.checkClosed();
            return 1000;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        try {
            this.debugCodeCall("getMaxRows");
            this.checkClosed();
            return this.maxRows;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        try {
            this.debugCodeCall("getLargeMaxRows");
            this.checkClosed();
            return this.maxRows;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setMaxRows(int n) throws SQLException {
        try {
            this.debugCodeCall("setMaxRows", n);
            this.checkClosed();
            if (n < 0) {
                throw DbException.getInvalidValueException("maxRows", n);
            }
            this.maxRows = n;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setLargeMaxRows(long l) throws SQLException {
        try {
            this.debugCodeCall("setLargeMaxRows", l);
            this.checkClosed();
            if (l < 0L) {
                throw DbException.getInvalidValueException("maxRows", l);
            }
            this.maxRows = l <= Integer.MAX_VALUE ? (int)l : 0;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        try {
            this.debugCodeCall("setFetchSize", n);
            this.checkClosed();
            if (n < 0 || n > 0 && this.maxRows > 0 && n > this.maxRows) {
                throw DbException.getInvalidValueException("rows", n);
            }
            if (n == 0) {
                n = SysProperties.SERVER_RESULT_SET_FETCH_SIZE;
            }
            this.fetchSize = n;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        try {
            this.debugCodeCall("getFetchSize");
            this.checkClosed();
            return this.fetchSize;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        try {
            this.debugCodeCall("getResultSetConcurrency");
            this.checkClosed();
            return this.resultSetConcurrency;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int getResultSetType() throws SQLException {
        try {
            this.debugCodeCall("getResultSetType");
            this.checkClosed();
            return this.resultSetType;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        try {
            this.debugCodeCall("getMaxFieldSize");
            this.checkClosed();
            return 0;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setMaxFieldSize(int n) throws SQLException {
        try {
            this.debugCodeCall("setMaxFieldSize", n);
            this.checkClosed();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setEscapeProcessing(boolean bl) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("setEscapeProcessing(" + bl + ");");
            }
            this.checkClosed();
            this.escapeProcessing = bl;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() throws SQLException {
        try {
            this.debugCodeCall("cancel");
            this.checkClosed();
            CommandInterface commandInterface = this.executingCommand;
            try {
                if (commandInterface != null) {
                    commandInterface.cancel();
                    this.cancelled = true;
                }
            }
            finally {
                this.setExecutingStatement(null);
            }
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        try {
            this.debugCodeCall("getQueryTimeout");
            this.checkClosed();
            return this.conn.getQueryTimeout();
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void setQueryTimeout(int n) throws SQLException {
        try {
            this.debugCodeCall("setQueryTimeout", n);
            this.checkClosed();
            if (n < 0) {
                throw DbException.getInvalidValueException("seconds", n);
            }
            this.conn.setQueryTimeout(n);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void addBatch(String string2) throws SQLException {
        try {
            this.debugCodeCall("addBatch", string2);
            this.checkClosed();
            string2 = JdbcConnection.translateSQL(string2, this.escapeProcessing);
            if (this.batchCommands == null) {
                this.batchCommands = New.arrayList();
            }
            this.batchCommands.add(string2);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        try {
            this.debugCodeCall("clearBatch");
            this.checkClosed();
            this.batchCommands = null;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        this.debugCodeCall("executeBatch");
        this.checkClosedForWrite();
        try {
            if (this.batchCommands == null) {
                this.batchCommands = New.arrayList();
            }
            int n = this.batchCommands.size();
            int[] nArray = new int[n];
            boolean bl = false;
            SQLException sQLException = null;
            for (int i = 0; i < n; ++i) {
                String string2 = this.batchCommands.get(i);
                try {
                    nArray[i] = this.executeUpdateInternal(string2, false);
                    continue;
                }
                catch (Exception exception) {
                    SQLException sQLException2 = this.logAndConvert(exception);
                    if (sQLException == null) {
                        sQLException = sQLException2;
                    } else {
                        sQLException2.setNextException(sQLException);
                        sQLException = sQLException2;
                    }
                    nArray[i] = -3;
                    bl = true;
                }
            }
            this.batchCommands = null;
            if (bl) {
                throw new JdbcBatchUpdateException(sQLException, nArray);
            }
            int[] nArray2 = nArray;
            this.afterWriting();
            return nArray2;
        }
        catch (Throwable throwable) {
            try {
                this.afterWriting();
                throw throwable;
            }
            catch (Exception exception) {
                throw this.logAndConvert(exception);
            }
        }
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        int[] nArray = this.executeBatch();
        int n = nArray.length;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = nArray[i];
        }
        return lArray;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        try {
            int n = JdbcStatement.getNextId(4);
            if (this.isDebugEnabled()) {
                this.debugCodeAssign("ResultSet", 4, n, "getGeneratedKeys()");
            }
            this.checkClosed();
            if (!this.conn.scopeGeneratedKeys()) {
                if (this.generatedKeys != null) {
                    return this.generatedKeys;
                }
                if (this.session.isSupportsGeneratedKeys()) {
                    return new SimpleResultSet();
                }
            }
            return this.conn.getGeneratedKeys(this, n);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        try {
            this.debugCodeCall("getMoreResults");
            this.checkClosed();
            this.closeOldResultSet();
            return false;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean getMoreResults(int n) throws SQLException {
        try {
            this.debugCodeCall("getMoreResults", n);
            switch (n) {
                case 1: 
                case 3: {
                    this.checkClosed();
                    this.closeOldResultSet();
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    throw DbException.getInvalidValueException("current", n);
                }
            }
            return false;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int executeUpdate(String string2, int n) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("executeUpdate(" + JdbcStatement.quote(string2) + ", " + n + ");");
            }
            return this.executeUpdateInternal(string2, n == 1);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public long executeLargeUpdate(String string2, int n) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("executeLargeUpdate(" + JdbcStatement.quote(string2) + ", " + n + ");");
            }
            return this.executeUpdateInternal(string2, n == 1);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int executeUpdate(String string2, int[] nArray) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("executeUpdate(" + JdbcStatement.quote(string2) + ", " + JdbcStatement.quoteIntArray(nArray) + ");");
            }
            return this.executeUpdateInternal(string2, nArray);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public long executeLargeUpdate(String string2, int[] nArray) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("executeLargeUpdate(" + JdbcStatement.quote(string2) + ", " + JdbcStatement.quoteIntArray(nArray) + ");");
            }
            return this.executeUpdateInternal(string2, nArray);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int executeUpdate(String string2, String[] stringArray) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("executeUpdate(" + JdbcStatement.quote(string2) + ", " + JdbcStatement.quoteArray(stringArray) + ");");
            }
            return this.executeUpdateInternal(string2, stringArray);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public long executeLargeUpdate(String string2, String[] stringArray) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("executeLargeUpdate(" + JdbcStatement.quote(string2) + ", " + JdbcStatement.quoteArray(stringArray) + ");");
            }
            return this.executeUpdateInternal(string2, stringArray);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean execute(String string2, int n) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("execute(" + JdbcStatement.quote(string2) + ", " + n + ");");
            }
            return this.executeInternal(string2, n == 1);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean execute(String string2, int[] nArray) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("execute(" + JdbcStatement.quote(string2) + ", " + JdbcStatement.quoteIntArray(nArray) + ");");
            }
            return this.executeInternal(string2, nArray);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean execute(String string2, String[] stringArray) throws SQLException {
        try {
            if (this.isDebugEnabled()) {
                this.debugCode("execute(" + JdbcStatement.quote(string2) + ", " + JdbcStatement.quoteArray(stringArray) + ");");
            }
            return this.executeInternal(string2, stringArray);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        try {
            this.debugCodeCall("getResultSetHoldability");
            this.checkClosed();
            return 1;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public void closeOnCompletion() {
    }

    @Override
    public boolean isCloseOnCompletion() {
        return true;
    }

    boolean checkClosed() {
        return this.checkClosed(false);
    }

    boolean checkClosedForWrite() {
        return this.checkClosed(true);
    }

    protected boolean checkClosed(boolean bl) {
        if (this.conn == null) {
            throw DbException.get(90007);
        }
        this.conn.checkClosed(bl);
        SessionInterface sessionInterface = this.conn.getSession();
        if (sessionInterface != this.session) {
            this.session = sessionInterface;
            this.trace = this.session.getTrace();
            return true;
        }
        return false;
    }

    void afterWriting() {
        if (this.conn != null) {
            this.conn.afterWriting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeOldResultSet() throws SQLException {
        try {
            if (!this.closedByResultSet) {
                if (this.resultSet != null) {
                    this.resultSet.closeInternal();
                }
                if (this.generatedKeys != null) {
                    this.generatedKeys.closeInternal();
                }
            }
        }
        finally {
            this.cancelled = false;
            this.resultSet = null;
            this.updateCount = -1;
            this.generatedKeys = null;
        }
    }

    protected void setExecutingStatement(CommandInterface commandInterface) {
        if (commandInterface == null) {
            this.conn.setExecutingStatement(null);
        } else {
            this.conn.setExecutingStatement(this);
            this.lastExecutedCommandType = commandInterface.getCommandType();
        }
        this.executingCommand = commandInterface;
    }

    void onLazyResultSetClose(CommandInterface commandInterface, boolean bl) {
        this.setExecutingStatement(null);
        commandInterface.stop();
        if (bl) {
            commandInterface.close();
        }
    }

    public int getLastExecutedCommandType() {
        return this.lastExecutedCommandType;
    }

    @Override
    public boolean isClosed() throws SQLException {
        try {
            this.debugCodeCall("isClosed");
            return this.conn == null;
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        try {
            if (this.isWrapperFor(clazz)) {
                return (T)this;
            }
            throw DbException.getInvalidValueException("iface", clazz);
        }
        catch (Exception exception) {
            throw this.logAndConvert(exception);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz != null && clazz.isAssignableFrom(this.getClass());
    }

    @Override
    public boolean isPoolable() {
        this.debugCodeCall("isPoolable");
        return false;
    }

    @Override
    public void setPoolable(boolean bl) {
        if (this.isDebugEnabled()) {
            this.debugCode("setPoolable(" + bl + ");");
        }
    }

    @Override
    public String enquoteIdentifier(String string2, boolean bl) throws SQLException {
        if (bl || !this.isSimpleIdentifier(string2)) {
            return StringUtils.quoteIdentifier(string2);
        }
        return string2;
    }

    @Override
    public boolean isSimpleIdentifier(String string2) throws SQLException {
        return ParserUtil.isSimpleIdentifier(string2, true);
    }

    public String toString() {
        return this.getTraceObjectName();
    }
}

