/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.index;

import com.alibaba.schedulerx.shade.org.h2.engine.Session;
import com.alibaba.schedulerx.shade.org.h2.index.BaseIndex;
import com.alibaba.schedulerx.shade.org.h2.index.Cursor;
import com.alibaba.schedulerx.shade.org.h2.index.IndexType;
import com.alibaba.schedulerx.shade.org.h2.index.SingleRowCursor;
import com.alibaba.schedulerx.shade.org.h2.message.DbException;
import com.alibaba.schedulerx.shade.org.h2.result.Row;
import com.alibaba.schedulerx.shade.org.h2.result.SearchRow;
import com.alibaba.schedulerx.shade.org.h2.result.SortOrder;
import com.alibaba.schedulerx.shade.org.h2.table.Column;
import com.alibaba.schedulerx.shade.org.h2.table.IndexColumn;
import com.alibaba.schedulerx.shade.org.h2.table.RegularTable;
import com.alibaba.schedulerx.shade.org.h2.table.TableFilter;
import com.alibaba.schedulerx.shade.org.h2.util.ValueHashMap;
import com.alibaba.schedulerx.shade.org.h2.value.Value;
import java.util.HashSet;

public class HashIndex
extends BaseIndex {
    private final int indexColumn;
    private final RegularTable tableData;
    private ValueHashMap<Long> rows;

    public HashIndex(RegularTable regularTable, int n, String string2, IndexColumn[] indexColumnArray, IndexType indexType) {
        this.initBaseIndex(regularTable, n, string2, indexColumnArray, indexType);
        this.indexColumn = indexColumnArray[0].column.getColumnId();
        this.tableData = regularTable;
        this.reset();
    }

    private void reset() {
        this.rows = ValueHashMap.newInstance();
    }

    @Override
    public void truncate(Session session) {
        this.reset();
    }

    @Override
    public void add(Session session, Row row) {
        Value value2 = row.getValue(this.indexColumn);
        Long l = this.rows.get(value2);
        if (l != null) {
            throw this.getDuplicateKeyException(value2.toString());
        }
        this.rows.put(value2, row.getKey());
    }

    @Override
    public void remove(Session session, Row row) {
        this.rows.remove(row.getValue(this.indexColumn));
    }

    @Override
    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) {
        if (searchRow == null || searchRow2 == null) {
            throw DbException.throwInternalError(searchRow + " " + searchRow2);
        }
        Value value2 = searchRow.getValue(this.indexColumn);
        Long l = this.rows.get(value2 = value2.convertTo(this.tableData.getColumn(this.indexColumn).getType()));
        Row row = l == null ? null : this.tableData.getRow(session, l.intValue());
        return new SingleRowCursor(row);
    }

    @Override
    public long getRowCount(Session session) {
        return this.getRowCountApproximation();
    }

    @Override
    public long getRowCountApproximation() {
        return this.rows.size();
    }

    @Override
    public long getDiskSpaceUsed() {
        return 0L;
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void remove(Session session) {
    }

    @Override
    public double getCost(Session session, int[] nArray, TableFilter[] tableFilterArray, int n, SortOrder sortOrder, HashSet<Column> hashSet) {
        for (Column column : this.columns) {
            int n2 = column.getColumnId();
            int n3 = nArray[n2];
            if ((n3 & 1) == 1) continue;
            return 9.223372036854776E18;
        }
        return 2.0;
    }

    @Override
    public void checkRename() {
    }

    @Override
    public boolean needRebuild() {
        return true;
    }

    @Override
    public boolean canGetFirstOrLast() {
        return false;
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean bl) {
        throw DbException.getUnsupportedException("HASH");
    }

    @Override
    public boolean canScan() {
        return false;
    }
}

