/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.expression;

import com.alibaba.schedulerx.shade.org.h2.engine.Session;
import com.alibaba.schedulerx.shade.org.h2.expression.Comparison;
import com.alibaba.schedulerx.shade.org.h2.expression.Condition;
import com.alibaba.schedulerx.shade.org.h2.expression.Expression;
import com.alibaba.schedulerx.shade.org.h2.expression.ExpressionColumn;
import com.alibaba.schedulerx.shade.org.h2.expression.ExpressionVisitor;
import com.alibaba.schedulerx.shade.org.h2.index.IndexCondition;
import com.alibaba.schedulerx.shade.org.h2.message.DbException;
import com.alibaba.schedulerx.shade.org.h2.table.ColumnResolver;
import com.alibaba.schedulerx.shade.org.h2.table.TableFilter;
import com.alibaba.schedulerx.shade.org.h2.util.StatementBuilder;
import com.alibaba.schedulerx.shade.org.h2.value.Value;
import com.alibaba.schedulerx.shade.org.h2.value.ValueBoolean;
import com.alibaba.schedulerx.shade.org.h2.value.ValueNull;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.TreeSet;

public class ConditionInConstantSet
extends Condition {
    private Expression left;
    private int queryLevel;
    private final ArrayList<Expression> valueList;
    private final TreeSet<Value> valueSet;

    public ConditionInConstantSet(final Session session, Expression expression, ArrayList<Expression> arrayList) {
        this.left = expression;
        this.valueList = arrayList;
        this.valueSet = new TreeSet<Value>(new Comparator<Value>(){

            @Override
            public int compare(Value value2, Value value3) {
                return session.getDatabase().compare(value2, value3);
            }
        });
        int n = expression.getType();
        for (Expression expression2 : arrayList) {
            this.valueSet.add(expression2.getValue(session).convertTo(n));
        }
    }

    @Override
    public Value getValue(Session session) {
        boolean bl;
        Value value2 = this.left.getValue(session);
        if (value2 == ValueNull.INSTANCE) {
            return value2;
        }
        boolean bl2 = this.valueSet.contains(value2);
        if (!bl2 && (bl = this.valueSet.contains(ValueNull.INSTANCE))) {
            return ValueNull.INSTANCE;
        }
        return ValueBoolean.get(bl2);
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n) {
        this.left.mapColumns(columnResolver, n);
        this.queryLevel = Math.max(n, this.queryLevel);
    }

    @Override
    public Expression optimize(Session session) {
        this.left = this.left.optimize(session);
        return this;
    }

    @Override
    public void createIndexConditions(Session session, TableFilter tableFilter) {
        if (!(this.left instanceof ExpressionColumn)) {
            return;
        }
        ExpressionColumn expressionColumn = (ExpressionColumn)this.left;
        if (tableFilter != expressionColumn.getTableFilter()) {
            return;
        }
        if (session.getDatabase().getSettings().optimizeInList) {
            tableFilter.addIndexCondition(IndexCondition.getInList(expressionColumn, this.valueList));
        }
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.left.setEvaluatable(tableFilter, bl);
    }

    @Override
    public String getSQL() {
        StatementBuilder statementBuilder = new StatementBuilder("(");
        statementBuilder.append(this.left.getSQL()).append(" IN(");
        for (Expression expression : this.valueList) {
            statementBuilder.appendExceptFirst(", ");
            statementBuilder.append(expression.getSQL());
        }
        return statementBuilder.append("))").toString();
    }

    @Override
    public void updateAggregate(Session session) {
        this.left.updateAggregate(session);
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        if (!this.left.isEverything(expressionVisitor)) {
            return false;
        }
        switch (expressionVisitor.getType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return true;
            }
        }
        throw DbException.throwInternalError("type=" + expressionVisitor.getType());
    }

    @Override
    public int getCost() {
        return this.left.getCost();
    }

    Expression getAdditional(Session session, Comparison comparison) {
        Expression expression = comparison.getIfEquals(this.left);
        if (expression != null && expression.isConstant()) {
            this.valueList.add(expression);
            this.valueSet.add(expression.getValue(session).convertTo(this.left.getType()));
            return this;
        }
        return null;
    }
}

