/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.h2.command.ddl;

import com.alibaba.schedulerx.shade.org.h2.command.ddl.SchemaCommand;
import com.alibaba.schedulerx.shade.org.h2.constraint.Constraint;
import com.alibaba.schedulerx.shade.org.h2.engine.Database;
import com.alibaba.schedulerx.shade.org.h2.engine.Session;
import com.alibaba.schedulerx.shade.org.h2.index.Index;
import com.alibaba.schedulerx.shade.org.h2.message.DbException;
import com.alibaba.schedulerx.shade.org.h2.schema.Schema;
import com.alibaba.schedulerx.shade.org.h2.table.Table;
import java.util.ArrayList;

public class DropIndex
extends SchemaCommand {
    private String indexName;
    private boolean ifExists;

    public DropIndex(Session session, Schema schema) {
        super(session, schema);
    }

    public void setIfExists(boolean bl) {
        this.ifExists = bl;
    }

    public void setIndexName(String string2) {
        this.indexName = string2;
    }

    @Override
    public int update() {
        this.session.commit(true);
        Database database = this.session.getDatabase();
        Index index2 = this.getSchema().findIndex(this.session, this.indexName);
        if (index2 == null) {
            if (!this.ifExists) {
                throw DbException.get(42112, this.indexName);
            }
        } else {
            Table table = index2.getTable();
            this.session.getUser().checkRight(index2.getTable(), 15);
            Constraint constraint = null;
            ArrayList<Constraint> arrayList = table.getConstraints();
            for (int i = 0; arrayList != null && i < arrayList.size(); ++i) {
                Constraint constraint2 = arrayList.get(i);
                if (!constraint2.usesIndex(index2)) continue;
                if (Constraint.Type.PRIMARY_KEY == constraint2.getConstraintType()) {
                    constraint = constraint2;
                    continue;
                }
                throw DbException.get(90085, this.indexName, constraint2.getName());
            }
            index2.getTable().setModified();
            if (constraint != null) {
                database.removeSchemaObject(this.session, constraint);
            } else {
                database.removeSchemaObject(this.session, index2);
            }
        }
        return 0;
    }

    @Override
    public int getType() {
        return 40;
    }
}

