/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.apache.http.entity.mime;

import com.alibaba.schedulerx.shade.org.apache.http.entity.mime.MinimalField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Header
implements Iterable<MinimalField> {
    private final List<MinimalField> fields = new LinkedList<MinimalField>();
    private final Map<String, List<MinimalField>> fieldMap = new HashMap<String, List<MinimalField>>();

    public void addField(MinimalField field2) {
        if (field2 == null) {
            return;
        }
        String key = field2.getName().toLowerCase(Locale.ENGLISH);
        List<MinimalField> values2 = this.fieldMap.get(key);
        if (values2 == null) {
            values2 = new LinkedList<MinimalField>();
            this.fieldMap.put(key, values2);
        }
        values2.add(field2);
        this.fields.add(field2);
    }

    public List<MinimalField> getFields() {
        return new ArrayList<MinimalField>(this.fields);
    }

    public MinimalField getField(String name) {
        if (name == null) {
            return null;
        }
        String key = name.toLowerCase(Locale.ENGLISH);
        List<MinimalField> list = this.fieldMap.get(key);
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public List<MinimalField> getFields(String name) {
        if (name == null) {
            return null;
        }
        String key = name.toLowerCase(Locale.ENGLISH);
        List<MinimalField> list = this.fieldMap.get(key);
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<MinimalField>(list);
    }

    public int removeFields(String name) {
        if (name == null) {
            return 0;
        }
        String key = name.toLowerCase(Locale.ENGLISH);
        List<MinimalField> removed = this.fieldMap.remove(key);
        if (removed == null || removed.isEmpty()) {
            return 0;
        }
        this.fields.removeAll(removed);
        return removed.size();
    }

    public void setField(MinimalField field2) {
        if (field2 == null) {
            return;
        }
        String key = field2.getName().toLowerCase(Locale.ENGLISH);
        List<MinimalField> list = this.fieldMap.get(key);
        if (list == null || list.isEmpty()) {
            this.addField(field2);
            return;
        }
        list.clear();
        list.add(field2);
        int firstOccurrence = -1;
        int index2 = 0;
        Iterator<MinimalField> it = this.fields.iterator();
        while (it.hasNext()) {
            MinimalField f = it.next();
            if (f.getName().equalsIgnoreCase(field2.getName())) {
                it.remove();
                if (firstOccurrence == -1) {
                    firstOccurrence = index2;
                }
            }
            ++index2;
        }
        this.fields.add(firstOccurrence, field2);
    }

    @Override
    public Iterator<MinimalField> iterator() {
        return Collections.unmodifiableList(this.fields).iterator();
    }

    public String toString() {
        return this.fields.toString();
    }
}

