/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.apache.commons.validator.routines;

import com.alibaba.schedulerx.shade.org.apache.commons.validator.routines.AbstractNumberValidator;
import java.text.Format;
import java.util.Locale;

public class IntegerValidator
extends AbstractNumberValidator {
    private static final long serialVersionUID = 422081746310306596L;
    private static final IntegerValidator VALIDATOR = new IntegerValidator();

    public static IntegerValidator getInstance() {
        return VALIDATOR;
    }

    public IntegerValidator() {
        this(true, 0);
    }

    public IntegerValidator(boolean strict, int formatType) {
        super(strict, formatType, false);
    }

    public Integer validate(String value2) {
        return (Integer)this.parse(value2, null, null);
    }

    public Integer validate(String value2, String pattern) {
        return (Integer)this.parse(value2, pattern, null);
    }

    public Integer validate(String value2, Locale locale) {
        return (Integer)this.parse(value2, null, locale);
    }

    public Integer validate(String value2, String pattern, Locale locale) {
        return (Integer)this.parse(value2, pattern, locale);
    }

    public boolean isInRange(int value2, int min2, int max2) {
        return value2 >= min2 && value2 <= max2;
    }

    public boolean isInRange(Integer value2, int min2, int max2) {
        return this.isInRange((int)value2, min2, max2);
    }

    public boolean minValue(int value2, int min2) {
        return value2 >= min2;
    }

    public boolean minValue(Integer value2, int min2) {
        return this.minValue((int)value2, min2);
    }

    public boolean maxValue(int value2, int max2) {
        return value2 <= max2;
    }

    public boolean maxValue(Integer value2, int max2) {
        return this.maxValue((int)value2, max2);
    }

    protected Object processParsedValue(Object value2, Format formatter) {
        long longValue = ((Number)value2).longValue();
        if (longValue < Integer.MIN_VALUE || longValue > Integer.MAX_VALUE) {
            return null;
        }
        return new Integer((int)longValue);
    }
}

