/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.apache.commons.validator.routines;

import com.alibaba.schedulerx.shade.org.apache.commons.validator.routines.AbstractNumberValidator;
import java.text.Format;
import java.util.Locale;

public class FloatValidator
extends AbstractNumberValidator {
    private static final long serialVersionUID = -4513245432806414267L;
    private static final FloatValidator VALIDATOR = new FloatValidator();

    public static FloatValidator getInstance() {
        return VALIDATOR;
    }

    public FloatValidator() {
        this(true, 0);
    }

    public FloatValidator(boolean strict, int formatType) {
        super(strict, formatType, true);
    }

    public Float validate(String value2) {
        return (Float)this.parse(value2, null, null);
    }

    public Float validate(String value2, String pattern) {
        return (Float)this.parse(value2, pattern, null);
    }

    public Float validate(String value2, Locale locale) {
        return (Float)this.parse(value2, null, locale);
    }

    public Float validate(String value2, String pattern, Locale locale) {
        return (Float)this.parse(value2, pattern, locale);
    }

    public boolean isInRange(float value2, float min2, float max2) {
        return value2 >= min2 && value2 <= max2;
    }

    public boolean isInRange(Float value2, float min2, float max2) {
        return this.isInRange(value2.floatValue(), min2, max2);
    }

    public boolean minValue(float value2, float min2) {
        return value2 >= min2;
    }

    public boolean minValue(Float value2, float min2) {
        return this.minValue(value2.floatValue(), min2);
    }

    public boolean maxValue(float value2, float max2) {
        return value2 <= max2;
    }

    public boolean maxValue(Float value2, float max2) {
        return this.maxValue(value2.floatValue(), max2);
    }

    protected Object processParsedValue(Object value2, Format formatter) {
        double doubleValue = ((Number)value2).doubleValue();
        if (doubleValue > 0.0) {
            if (doubleValue < (double)1.4E-45f) {
                return null;
            }
            if (doubleValue > 3.4028234663852886E38) {
                return null;
            }
        } else if (doubleValue < 0.0) {
            double posDouble = doubleValue * -1.0;
            if (posDouble < (double)1.4E-45f) {
                return null;
            }
            if (posDouble > 3.4028234663852886E38) {
                return null;
            }
        }
        return new Float((float)doubleValue);
    }
}

