/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.apache.commons.validator.routines;

import com.alibaba.schedulerx.shade.org.apache.commons.validator.routines.AbstractCalendarValidator;
import java.text.Format;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateValidator
extends AbstractCalendarValidator {
    private static final long serialVersionUID = -3966328400469953190L;
    private static final DateValidator VALIDATOR = new DateValidator();

    public static DateValidator getInstance() {
        return VALIDATOR;
    }

    public DateValidator() {
        this(true, 3);
    }

    public DateValidator(boolean strict, int dateStyle) {
        super(strict, dateStyle, -1);
    }

    public Date validate(String value2) {
        return (Date)this.parse(value2, null, null, null);
    }

    public Date validate(String value2, TimeZone timeZone) {
        return (Date)this.parse(value2, null, null, timeZone);
    }

    public Date validate(String value2, String pattern) {
        return (Date)this.parse(value2, pattern, null, null);
    }

    public Date validate(String value2, String pattern, TimeZone timeZone) {
        return (Date)this.parse(value2, pattern, null, timeZone);
    }

    public Date validate(String value2, Locale locale) {
        return (Date)this.parse(value2, null, locale, null);
    }

    public Date validate(String value2, Locale locale, TimeZone timeZone) {
        return (Date)this.parse(value2, null, locale, timeZone);
    }

    public Date validate(String value2, String pattern, Locale locale) {
        return (Date)this.parse(value2, pattern, locale, null);
    }

    public Date validate(String value2, String pattern, Locale locale, TimeZone timeZone) {
        return (Date)this.parse(value2, pattern, locale, timeZone);
    }

    public int compareDates(Date value2, Date compare, TimeZone timeZone) {
        Calendar calendarValue = this.getCalendar(value2, timeZone);
        Calendar calendarCompare = this.getCalendar(compare, timeZone);
        return this.compare(calendarValue, calendarCompare, 5);
    }

    public int compareWeeks(Date value2, Date compare, TimeZone timeZone) {
        Calendar calendarValue = this.getCalendar(value2, timeZone);
        Calendar calendarCompare = this.getCalendar(compare, timeZone);
        return this.compare(calendarValue, calendarCompare, 3);
    }

    public int compareMonths(Date value2, Date compare, TimeZone timeZone) {
        Calendar calendarValue = this.getCalendar(value2, timeZone);
        Calendar calendarCompare = this.getCalendar(compare, timeZone);
        return this.compare(calendarValue, calendarCompare, 2);
    }

    public int compareQuarters(Date value2, Date compare, TimeZone timeZone) {
        return this.compareQuarters(value2, compare, timeZone, 1);
    }

    public int compareQuarters(Date value2, Date compare, TimeZone timeZone, int monthOfFirstQuarter) {
        Calendar calendarValue = this.getCalendar(value2, timeZone);
        Calendar calendarCompare = this.getCalendar(compare, timeZone);
        return super.compareQuarters(calendarValue, calendarCompare, monthOfFirstQuarter);
    }

    public int compareYears(Date value2, Date compare, TimeZone timeZone) {
        Calendar calendarValue = this.getCalendar(value2, timeZone);
        Calendar calendarCompare = this.getCalendar(compare, timeZone);
        return this.compare(calendarValue, calendarCompare, 1);
    }

    protected Object processParsedValue(Object value2, Format formatter) {
        return value2;
    }

    private Calendar getCalendar(Date value2, TimeZone timeZone) {
        Calendar calendar = null;
        calendar = timeZone != null ? Calendar.getInstance(timeZone) : Calendar.getInstance();
        calendar.setTime(value2);
        return calendar;
    }
}

