/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.apache.commons.validator.routines;

import com.alibaba.schedulerx.shade.org.apache.commons.validator.routines.AbstractCalendarValidator;
import java.text.DateFormat;
import java.text.Format;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;

public class CalendarValidator
extends AbstractCalendarValidator {
    private static final long serialVersionUID = 9109652318762134167L;
    private static final CalendarValidator VALIDATOR = new CalendarValidator();

    public static CalendarValidator getInstance() {
        return VALIDATOR;
    }

    public CalendarValidator() {
        this(true, 3);
    }

    public CalendarValidator(boolean strict, int dateStyle) {
        super(strict, dateStyle, -1);
    }

    public Calendar validate(String value2) {
        return (Calendar)this.parse(value2, null, null, null);
    }

    public Calendar validate(String value2, TimeZone timeZone) {
        return (Calendar)this.parse(value2, null, null, timeZone);
    }

    public Calendar validate(String value2, String pattern) {
        return (Calendar)this.parse(value2, pattern, null, null);
    }

    public Calendar validate(String value2, String pattern, TimeZone timeZone) {
        return (Calendar)this.parse(value2, pattern, null, timeZone);
    }

    public Calendar validate(String value2, Locale locale) {
        return (Calendar)this.parse(value2, null, locale, null);
    }

    public Calendar validate(String value2, Locale locale, TimeZone timeZone) {
        return (Calendar)this.parse(value2, null, locale, timeZone);
    }

    public Calendar validate(String value2, String pattern, Locale locale) {
        return (Calendar)this.parse(value2, pattern, locale, null);
    }

    public Calendar validate(String value2, String pattern, Locale locale, TimeZone timeZone) {
        return (Calendar)this.parse(value2, pattern, locale, timeZone);
    }

    public static void adjustToTimeZone(Calendar value2, TimeZone timeZone) {
        if (value2.getTimeZone().hasSameRules(timeZone)) {
            value2.setTimeZone(timeZone);
        } else {
            int year = value2.get(1);
            int month = value2.get(2);
            int date = value2.get(5);
            int hour = value2.get(11);
            int minute = value2.get(12);
            value2.setTimeZone(timeZone);
            value2.set(year, month, date, hour, minute);
        }
    }

    public int compareDates(Calendar value2, Calendar compare) {
        return this.compare(value2, compare, 5);
    }

    public int compareWeeks(Calendar value2, Calendar compare) {
        return this.compare(value2, compare, 3);
    }

    public int compareMonths(Calendar value2, Calendar compare) {
        return this.compare(value2, compare, 2);
    }

    public int compareQuarters(Calendar value2, Calendar compare) {
        return this.compareQuarters(value2, compare, 1);
    }

    public int compareQuarters(Calendar value2, Calendar compare, int monthOfFirstQuarter) {
        return super.compareQuarters(value2, compare, monthOfFirstQuarter);
    }

    public int compareYears(Calendar value2, Calendar compare) {
        return this.compare(value2, compare, 1);
    }

    protected Object processParsedValue(Object value2, Format formatter) {
        return ((DateFormat)formatter).getCalendar();
    }
}

