/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.apache.commons.validator.routines;

import com.alibaba.schedulerx.shade.org.apache.commons.validator.routines.AbstractFormatValidator;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Locale;

public abstract class AbstractNumberValidator
extends AbstractFormatValidator {
    private static final long serialVersionUID = -3088817875906765463L;
    public static final int STANDARD_FORMAT = 0;
    public static final int CURRENCY_FORMAT = 1;
    public static final int PERCENT_FORMAT = 2;
    private final boolean allowFractions;
    private final int formatType;

    public AbstractNumberValidator(boolean strict, int formatType, boolean allowFractions) {
        super(strict);
        this.allowFractions = allowFractions;
        this.formatType = formatType;
    }

    public boolean isAllowFractions() {
        return this.allowFractions;
    }

    public int getFormatType() {
        return this.formatType;
    }

    public boolean isValid(String value2, String pattern, Locale locale) {
        Object parsedValue = this.parse(value2, pattern, locale);
        return parsedValue != null;
    }

    public boolean isInRange(Number value2, Number min2, Number max2) {
        return this.minValue(value2, min2) && this.maxValue(value2, max2);
    }

    public boolean minValue(Number value2, Number min2) {
        if (this.isAllowFractions()) {
            return value2.doubleValue() >= min2.doubleValue();
        }
        return value2.longValue() >= min2.longValue();
    }

    public boolean maxValue(Number value2, Number max2) {
        if (this.isAllowFractions()) {
            return value2.doubleValue() <= max2.doubleValue();
        }
        return value2.longValue() <= max2.longValue();
    }

    protected Object parse(String value2, String pattern, Locale locale) {
        String string2 = value2 = value2 == null ? null : value2.trim();
        if (value2 == null || value2.length() == 0) {
            return null;
        }
        Format formatter = this.getFormat(pattern, locale);
        return this.parse(value2, formatter);
    }

    protected abstract Object processParsedValue(Object var1, Format var2);

    protected Format getFormat(String pattern, Locale locale) {
        boolean usePattern;
        NumberFormat formatter = null;
        boolean bl = usePattern = pattern != null && pattern.length() > 0;
        if (!usePattern) {
            formatter = (NumberFormat)this.getFormat(locale);
        } else if (locale == null) {
            formatter = new DecimalFormat(pattern);
        } else {
            DecimalFormatSymbols symbols = new DecimalFormatSymbols(locale);
            formatter = new DecimalFormat(pattern, symbols);
        }
        if (this.determineScale(formatter) == 0) {
            formatter.setParseIntegerOnly(true);
        }
        return formatter;
    }

    protected int determineScale(NumberFormat format2) {
        int maximumFraction;
        if (!this.isStrict()) {
            return -1;
        }
        if (!this.isAllowFractions() || format2.isParseIntegerOnly()) {
            return 0;
        }
        int minimumFraction = format2.getMinimumFractionDigits();
        if (minimumFraction != (maximumFraction = format2.getMaximumFractionDigits())) {
            return -1;
        }
        int scale = minimumFraction;
        if (format2 instanceof DecimalFormat) {
            int multiplier = ((DecimalFormat)format2).getMultiplier();
            if (multiplier == 100) {
                scale += 2;
            } else if (multiplier == 1000) {
                scale += 3;
            }
        } else if (this.formatType == 2) {
            scale += 2;
        }
        return scale;
    }

    protected Format getFormat(Locale locale) {
        NumberFormat formatter = null;
        switch (this.formatType) {
            case 1: {
                if (locale == null) {
                    formatter = NumberFormat.getCurrencyInstance();
                    break;
                }
                formatter = NumberFormat.getCurrencyInstance(locale);
                break;
            }
            case 2: {
                if (locale == null) {
                    formatter = NumberFormat.getPercentInstance();
                    break;
                }
                formatter = NumberFormat.getPercentInstance(locale);
                break;
            }
            default: {
                formatter = locale == null ? NumberFormat.getInstance() : NumberFormat.getInstance(locale);
            }
        }
        return formatter;
    }
}

