/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.apache.commons.validator.routines;

import java.io.Serializable;
import java.text.Format;
import java.text.ParsePosition;
import java.util.Locale;

public abstract class AbstractFormatValidator
implements Serializable {
    private static final long serialVersionUID = -4690687565200568258L;
    private final boolean strict;

    public AbstractFormatValidator(boolean strict) {
        this.strict = strict;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public boolean isValid(String value2) {
        return this.isValid(value2, null, null);
    }

    public boolean isValid(String value2, String pattern) {
        return this.isValid(value2, pattern, null);
    }

    public boolean isValid(String value2, Locale locale) {
        return this.isValid(value2, null, locale);
    }

    public abstract boolean isValid(String var1, String var2, Locale var3);

    public String format(Object value2) {
        return this.format(value2, null, null);
    }

    public String format(Object value2, String pattern) {
        return this.format(value2, pattern, null);
    }

    public String format(Object value2, Locale locale) {
        return this.format(value2, null, locale);
    }

    public String format(Object value2, String pattern, Locale locale) {
        Format formatter = this.getFormat(pattern, locale);
        return this.format(value2, formatter);
    }

    protected String format(Object value2, Format formatter) {
        return formatter.format(value2);
    }

    protected Object parse(String value2, Format formatter) {
        ParsePosition pos = new ParsePosition(0);
        Object parsedValue = formatter.parseObject(value2, pos);
        if (pos.getErrorIndex() > -1) {
            return null;
        }
        if (this.isStrict() && pos.getIndex() < value2.length()) {
            return null;
        }
        if (parsedValue != null) {
            parsedValue = this.processParsedValue(parsedValue, formatter);
        }
        return parsedValue;
    }

    protected abstract Object processParsedValue(Object var1, Format var2);

    protected abstract Format getFormat(String var1, Locale var2);
}

