/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.apache.commons.validator;

import com.alibaba.schedulerx.shade.org.apache.commons.validator.GenericTypeValidator;
import com.alibaba.schedulerx.shade.org.apache.commons.validator.routines.CreditCardValidator;
import com.alibaba.schedulerx.shade.org.apache.commons.validator.routines.DateValidator;
import com.alibaba.schedulerx.shade.org.apache.commons.validator.routines.EmailValidator;
import com.alibaba.schedulerx.shade.org.apache.commons.validator.routines.UrlValidator;
import java.io.Serializable;
import java.util.Locale;
import java.util.regex.Pattern;

public class GenericValidator
implements Serializable {
    private static final long serialVersionUID = -7212095066891517618L;
    private static final UrlValidator URL_VALIDATOR = new UrlValidator();
    private static final CreditCardValidator CREDIT_CARD_VALIDATOR = new CreditCardValidator();

    public static boolean isBlankOrNull(String value2) {
        return value2 == null || value2.trim().length() == 0;
    }

    public static boolean matchRegexp(String value2, String regexp) {
        if (regexp == null || regexp.length() <= 0) {
            return false;
        }
        return Pattern.matches(regexp, value2);
    }

    public static boolean isByte(String value2) {
        return GenericTypeValidator.formatByte(value2) != null;
    }

    public static boolean isShort(String value2) {
        return GenericTypeValidator.formatShort(value2) != null;
    }

    public static boolean isInt(String value2) {
        return GenericTypeValidator.formatInt(value2) != null;
    }

    public static boolean isLong(String value2) {
        return GenericTypeValidator.formatLong(value2) != null;
    }

    public static boolean isFloat(String value2) {
        return GenericTypeValidator.formatFloat(value2) != null;
    }

    public static boolean isDouble(String value2) {
        return GenericTypeValidator.formatDouble(value2) != null;
    }

    public static boolean isDate(String value2, Locale locale) {
        return DateValidator.getInstance().isValid(value2, locale);
    }

    public static boolean isDate(String value2, String datePattern, boolean strict) {
        return com.alibaba.schedulerx.shade.org.apache.commons.validator.DateValidator.getInstance().isValid(value2, datePattern, strict);
    }

    public static boolean isInRange(byte value2, byte min2, byte max2) {
        return value2 >= min2 && value2 <= max2;
    }

    public static boolean isInRange(int value2, int min2, int max2) {
        return value2 >= min2 && value2 <= max2;
    }

    public static boolean isInRange(float value2, float min2, float max2) {
        return value2 >= min2 && value2 <= max2;
    }

    public static boolean isInRange(short value2, short min2, short max2) {
        return value2 >= min2 && value2 <= max2;
    }

    public static boolean isInRange(long value2, long min2, long max2) {
        return value2 >= min2 && value2 <= max2;
    }

    public static boolean isInRange(double value2, double min2, double max2) {
        return value2 >= min2 && value2 <= max2;
    }

    public static boolean isCreditCard(String value2) {
        return CREDIT_CARD_VALIDATOR.isValid(value2);
    }

    public static boolean isEmail(String value2) {
        return EmailValidator.getInstance().isValid(value2);
    }

    public static boolean isUrl(String value2) {
        return URL_VALIDATOR.isValid(value2);
    }

    public static boolean maxLength(String value2, int max2) {
        return value2.length() <= max2;
    }

    public static boolean maxLength(String value2, int max2, int lineEndLength) {
        int adjustAmount = GenericValidator.adjustForLineEnding(value2, lineEndLength);
        return value2.length() + adjustAmount <= max2;
    }

    public static boolean minLength(String value2, int min2) {
        return value2.length() >= min2;
    }

    public static boolean minLength(String value2, int min2, int lineEndLength) {
        int adjustAmount = GenericValidator.adjustForLineEnding(value2, lineEndLength);
        return value2.length() + adjustAmount >= min2;
    }

    private static int adjustForLineEnding(String value2, int lineEndLength) {
        int nCount = 0;
        int rCount = 0;
        for (int i = 0; i < value2.length(); ++i) {
            if (value2.charAt(i) == '\n') {
                ++nCount;
            }
            if (value2.charAt(i) != '\r') continue;
            ++rCount;
        }
        return nCount * lineEndLength - (rCount + nCount);
    }

    public static boolean minValue(int value2, int min2) {
        return value2 >= min2;
    }

    public static boolean minValue(long value2, long min2) {
        return value2 >= min2;
    }

    public static boolean minValue(double value2, double min2) {
        return value2 >= min2;
    }

    public static boolean minValue(float value2, float min2) {
        return value2 >= min2;
    }

    public static boolean maxValue(int value2, int max2) {
        return value2 <= max2;
    }

    public static boolean maxValue(long value2, long max2) {
        return value2 <= max2;
    }

    public static boolean maxValue(double value2, double max2) {
        return value2 <= max2;
    }

    public static boolean maxValue(float value2, float max2) {
        return value2 <= max2;
    }
}

