/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.apache.commons.validator;

import com.alibaba.schedulerx.shade.org.apache.commons.logging.Log;
import com.alibaba.schedulerx.shade.org.apache.commons.logging.LogFactory;
import com.alibaba.schedulerx.shade.org.apache.commons.validator.GenericValidator;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class GenericTypeValidator
implements Serializable {
    private static final long serialVersionUID = 5487162314134261703L;

    public static Byte formatByte(String value2) {
        if (value2 == null) {
            return null;
        }
        try {
            return new Byte(value2);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Byte formatByte(String value2, Locale locale) {
        Byte result2 = null;
        if (value2 != null) {
            NumberFormat formatter = null;
            formatter = locale != null ? NumberFormat.getNumberInstance(locale) : NumberFormat.getNumberInstance(Locale.getDefault());
            formatter.setParseIntegerOnly(true);
            ParsePosition pos = new ParsePosition(0);
            Number num = formatter.parse(value2, pos);
            if (pos.getErrorIndex() == -1 && pos.getIndex() == value2.length() && num.doubleValue() >= -128.0 && num.doubleValue() <= 127.0) {
                result2 = new Byte(num.byteValue());
            }
        }
        return result2;
    }

    public static Short formatShort(String value2) {
        if (value2 == null) {
            return null;
        }
        try {
            return new Short(value2);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Short formatShort(String value2, Locale locale) {
        Short result2 = null;
        if (value2 != null) {
            NumberFormat formatter = null;
            formatter = locale != null ? NumberFormat.getNumberInstance(locale) : NumberFormat.getNumberInstance(Locale.getDefault());
            formatter.setParseIntegerOnly(true);
            ParsePosition pos = new ParsePosition(0);
            Number num = formatter.parse(value2, pos);
            if (pos.getErrorIndex() == -1 && pos.getIndex() == value2.length() && num.doubleValue() >= -32768.0 && num.doubleValue() <= 32767.0) {
                result2 = new Short(num.shortValue());
            }
        }
        return result2;
    }

    public static Integer formatInt(String value2) {
        if (value2 == null) {
            return null;
        }
        try {
            return new Integer(value2);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Integer formatInt(String value2, Locale locale) {
        Integer result2 = null;
        if (value2 != null) {
            NumberFormat formatter = null;
            formatter = locale != null ? NumberFormat.getNumberInstance(locale) : NumberFormat.getNumberInstance(Locale.getDefault());
            formatter.setParseIntegerOnly(true);
            ParsePosition pos = new ParsePosition(0);
            Number num = formatter.parse(value2, pos);
            if (pos.getErrorIndex() == -1 && pos.getIndex() == value2.length() && num.doubleValue() >= -2.147483648E9 && num.doubleValue() <= 2.147483647E9) {
                result2 = new Integer(num.intValue());
            }
        }
        return result2;
    }

    public static Long formatLong(String value2) {
        if (value2 == null) {
            return null;
        }
        try {
            return new Long(value2);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Long formatLong(String value2, Locale locale) {
        Long result2 = null;
        if (value2 != null) {
            NumberFormat formatter = null;
            formatter = locale != null ? NumberFormat.getNumberInstance(locale) : NumberFormat.getNumberInstance(Locale.getDefault());
            formatter.setParseIntegerOnly(true);
            ParsePosition pos = new ParsePosition(0);
            Number num = formatter.parse(value2, pos);
            if (pos.getErrorIndex() == -1 && pos.getIndex() == value2.length() && num.doubleValue() >= -9.223372036854776E18 && num.doubleValue() <= 9.223372036854776E18) {
                result2 = new Long(num.longValue());
            }
        }
        return result2;
    }

    public static Float formatFloat(String value2) {
        if (value2 == null) {
            return null;
        }
        try {
            return new Float(value2);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Float formatFloat(String value2, Locale locale) {
        Float result2 = null;
        if (value2 != null) {
            NumberFormat formatter = null;
            formatter = locale != null ? NumberFormat.getInstance(locale) : NumberFormat.getInstance(Locale.getDefault());
            ParsePosition pos = new ParsePosition(0);
            Number num = formatter.parse(value2, pos);
            if (pos.getErrorIndex() == -1 && pos.getIndex() == value2.length() && num.doubleValue() >= -3.4028234663852886E38 && num.doubleValue() <= 3.4028234663852886E38) {
                result2 = new Float(num.floatValue());
            }
        }
        return result2;
    }

    public static Double formatDouble(String value2) {
        if (value2 == null) {
            return null;
        }
        try {
            return new Double(value2);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Double formatDouble(String value2, Locale locale) {
        Double result2 = null;
        if (value2 != null) {
            NumberFormat formatter = null;
            formatter = locale != null ? NumberFormat.getInstance(locale) : NumberFormat.getInstance(Locale.getDefault());
            ParsePosition pos = new ParsePosition(0);
            Number num = formatter.parse(value2, pos);
            if (pos.getErrorIndex() == -1 && pos.getIndex() == value2.length() && num.doubleValue() >= -1.7976931348623157E308 && num.doubleValue() <= Double.MAX_VALUE) {
                result2 = new Double(num.doubleValue());
            }
        }
        return result2;
    }

    public static Date formatDate(String value2, Locale locale) {
        Date date;
        block7: {
            date = null;
            if (value2 == null) {
                return null;
            }
            try {
                DateFormat formatterShort = null;
                DateFormat formatterDefault = null;
                if (locale != null) {
                    formatterShort = DateFormat.getDateInstance(3, locale);
                    formatterDefault = DateFormat.getDateInstance(2, locale);
                } else {
                    formatterShort = DateFormat.getDateInstance(3, Locale.getDefault());
                    formatterDefault = DateFormat.getDateInstance(2, Locale.getDefault());
                }
                formatterShort.setLenient(false);
                formatterDefault.setLenient(false);
                try {
                    date = formatterShort.parse(value2);
                }
                catch (ParseException e) {
                    date = formatterDefault.parse(value2);
                }
            }
            catch (ParseException e) {
                Log log2 = LogFactory.getLog(GenericTypeValidator.class);
                if (!log2.isDebugEnabled()) break block7;
                log2.debug("Date parse failed value=[" + value2 + "], " + "locale=[" + locale + "] " + e);
            }
        }
        return date;
    }

    public static Date formatDate(String value2, String datePattern, boolean strict) {
        Date date;
        block4: {
            date = null;
            if (value2 == null || datePattern == null || datePattern.length() == 0) {
                return null;
            }
            try {
                SimpleDateFormat formatter = new SimpleDateFormat(datePattern);
                formatter.setLenient(false);
                date = formatter.parse(value2);
                if (strict && datePattern.length() != value2.length()) {
                    date = null;
                }
            }
            catch (ParseException e) {
                Log log2 = LogFactory.getLog(GenericTypeValidator.class);
                if (!log2.isDebugEnabled()) break block4;
                log2.debug("Date parse failed value=[" + value2 + "], " + "pattern=[" + datePattern + "], " + "strict=[" + strict + "] " + e);
            }
        }
        return date;
    }

    public static Long formatCreditCard(String value2) {
        return GenericValidator.isCreditCard(value2) ? new Long(value2) : null;
    }
}

