/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.org.apache.commons.validator;

import com.alibaba.schedulerx.shade.org.apache.commons.validator.util.Flags;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class CreditCardValidator {
    public static final int NONE = 0;
    public static final int AMEX = 1;
    public static final int VISA = 2;
    public static final int MASTERCARD = 4;
    public static final int DISCOVER = 8;
    private Collection cardTypes = new ArrayList();

    public CreditCardValidator() {
        this(15);
    }

    public CreditCardValidator(int options) {
        Flags f = new Flags(options);
        if (f.isOn(2L)) {
            this.cardTypes.add(new Visa());
        }
        if (f.isOn(1L)) {
            this.cardTypes.add(new Amex());
        }
        if (f.isOn(4L)) {
            this.cardTypes.add(new Mastercard());
        }
        if (f.isOn(8L)) {
            this.cardTypes.add(new Discover());
        }
    }

    public boolean isValid(String card) {
        if (card == null || card.length() < 13 || card.length() > 19) {
            return false;
        }
        if (!this.luhnCheck(card)) {
            return false;
        }
        Iterator types = this.cardTypes.iterator();
        while (types.hasNext()) {
            CreditCardType type = (CreditCardType)types.next();
            if (!type.matches(card)) continue;
            return true;
        }
        return false;
    }

    public void addAllowedCardType(CreditCardType type) {
        this.cardTypes.add(type);
    }

    protected boolean luhnCheck(String cardNumber) {
        int digits = cardNumber.length();
        int oddOrEven = digits & 1;
        long sum2 = 0L;
        for (int count2 = 0; count2 < digits; ++count2) {
            int digit2 = 0;
            try {
                digit2 = Integer.parseInt(cardNumber.charAt(count2) + "");
            }
            catch (NumberFormatException e) {
                return false;
            }
            if ((count2 & 1 ^ oddOrEven) == 0 && (digit2 *= 2) > 9) {
                digit2 -= 9;
            }
            sum2 += (long)digit2;
        }
        return sum2 == 0L ? false : sum2 % 10L == 0L;
    }

    private static class Mastercard
    implements CreditCardType {
        private static final String PREFIX = "51,52,53,54,55,";

        private Mastercard() {
        }

        public boolean matches(String card) {
            String prefix2 = card.substring(0, 2) + ",";
            return PREFIX.indexOf(prefix2) != -1 && card.length() == 16;
        }
    }

    private static class Discover
    implements CreditCardType {
        private static final String PREFIX = "6011";

        private Discover() {
        }

        public boolean matches(String card) {
            return card.substring(0, 4).equals(PREFIX) && card.length() == 16;
        }
    }

    private static class Amex
    implements CreditCardType {
        private static final String PREFIX = "34,37,";

        private Amex() {
        }

        public boolean matches(String card) {
            String prefix2 = card.substring(0, 2) + ",";
            return PREFIX.indexOf(prefix2) != -1 && card.length() == 15;
        }
    }

    private static class Visa
    implements CreditCardType {
        private static final String PREFIX = "4";

        private Visa() {
        }

        public boolean matches(String card) {
            return card.substring(0, 1).equals(PREFIX) && (card.length() == 13 || card.length() == 16);
        }
    }

    public static interface CreditCardType {
        public boolean matches(String var1);
    }
}

