/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.net.sf.json.groovy;

import com.alibaba.schedulerx.shade.net.sf.json.JSON;
import com.alibaba.schedulerx.shade.net.sf.json.JSONArray;
import com.alibaba.schedulerx.shade.net.sf.json.JSONException;
import com.alibaba.schedulerx.shade.net.sf.json.JSONObject;
import com.alibaba.schedulerx.shade.net.sf.json.JSONSerializer;
import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.MissingMethodException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class JsonGroovyBuilder
extends GroovyObjectSupport {
    private static final String JSON = "json";
    private JSON current;
    private Map properties;
    private Stack stack = new Stack();

    public JsonGroovyBuilder() {
        this.properties = new HashMap();
    }

    public Object getProperty(String name) {
        if (!this.stack.isEmpty()) {
            Object top = this.stack.peek();
            if (top instanceof JSONObject) {
                JSONObject json = (JSONObject)top;
                if (json.containsKey(name)) {
                    return json.get(name);
                }
                return this._getProperty(name);
            }
            return this._getProperty(name);
        }
        return this._getProperty(name);
    }

    public Object invokeMethod(String name, Object arg) {
        if (JSON.equals(name) && this.stack.isEmpty()) {
            return this.createObject(name, arg);
        }
        Object[] args = (Object[])arg;
        if (args.length == 0) {
            throw new MissingMethodException(name, ((Object)((Object)this)).getClass(), args);
        }
        JSON value2 = null;
        if (args.length > 1) {
            JSONArray array = new JSONArray();
            this.stack.push(array);
            for (int i = 0; i < args.length; ++i) {
                if (args[i] instanceof Closure) {
                    this.append(name, this.createObject((Closure)args[i]));
                    continue;
                }
                if (args[i] instanceof Map) {
                    this.append(name, this.createObject((Map)args[i]));
                    continue;
                }
                if (args[i] instanceof List) {
                    this.append(name, this.createArray((List)args[i]));
                    continue;
                }
                this._append(name, args[i], (JSON)this.stack.peek());
            }
            this.stack.pop();
        } else if (args[0] instanceof Closure) {
            value2 = this.createObject((Closure)args[0]);
        } else if (args[0] instanceof Map) {
            value2 = this.createObject((Map)args[0]);
        } else if (args[0] instanceof List) {
            value2 = this.createArray((List)args[0]);
        }
        if (this.stack.isEmpty()) {
            JSONObject object = new JSONObject();
            object.accumulate(name, this.current);
            this.current = object;
        } else {
            JSON top = (JSON)this.stack.peek();
            if (top instanceof JSONObject) {
                this.append(name, this.current == null ? value2 : this.current);
            }
        }
        return this.current;
    }

    public void setProperty(String name, Object value2) {
        if (value2 instanceof GString) {
            value2 = value2.toString();
            try {
                value2 = JSONSerializer.toJSON(value2);
            }
            catch (JSONException jSONException) {}
        } else if (value2 instanceof Closure) {
            value2 = this.createObject((Closure)value2);
        } else if (value2 instanceof Map) {
            value2 = this.createObject((Map)value2);
        } else if (value2 instanceof List) {
            value2 = this.createArray((List)value2);
        }
        this.append(name, value2);
    }

    private Object _getProperty(String name) {
        if (this.properties.containsKey(name)) {
            return this.properties.get(name);
        }
        return super.getProperty(name);
    }

    private void append(String key, Object value2) {
        Object target = null;
        if (!this.stack.isEmpty()) {
            target = this.stack.peek();
            this.current = target;
            this._append(key, value2, this.current);
        } else {
            this.properties.put(key, value2);
        }
    }

    private void _append(String key, Object value2, JSON target) {
        if (target instanceof JSONObject) {
            ((JSONObject)target).accumulate(key, value2);
        } else if (target instanceof JSONArray) {
            ((JSONArray)target).element(value2);
        }
    }

    private JSON createArray(List list) {
        JSONArray array = new JSONArray();
        this.stack.push(array);
        Iterator elements = list.iterator();
        while (elements.hasNext()) {
            Object element = elements.next();
            if (element instanceof Closure) {
                element = this.createObject((Closure)element);
            } else if (element instanceof Map) {
                element = this.createObject((Map)element);
            } else if (element instanceof List) {
                element = this.createArray((List)element);
            }
            array.element(element);
        }
        this.stack.pop();
        return array;
    }

    private JSON createObject(Closure closure) {
        JSONObject object = new JSONObject();
        this.stack.push(object);
        closure.setDelegate((Object)this);
        closure.setResolveStrategy(1);
        closure.call();
        this.stack.pop();
        return object;
    }

    private JSON createObject(Map map2) {
        JSONObject object = new JSONObject();
        this.stack.push(object);
        Iterator properties = map2.entrySet().iterator();
        while (properties.hasNext()) {
            Map.Entry property = properties.next();
            String key = String.valueOf(property.getKey());
            Object value2 = property.getValue();
            if (value2 instanceof Closure) {
                value2 = this.createObject((Closure)value2);
            } else if (value2 instanceof Map) {
                value2 = this.createObject((Map)value2);
            } else if (value2 instanceof List) {
                value2 = this.createArray((List)value2);
            }
            object.element(key, value2);
        }
        this.stack.pop();
        return object;
    }

    private JSON createObject(String name, Object arg) {
        Object[] args = (Object[])arg;
        if (args.length == 0) {
            throw new MissingMethodException(name, ((Object)((Object)this)).getClass(), args);
        }
        if (args.length == 1) {
            if (args[0] instanceof Closure) {
                return this.createObject((Closure)args[0]);
            }
            if (args[0] instanceof Map) {
                return this.createObject((Map)args[0]);
            }
            if (args[0] instanceof List) {
                return this.createArray((List)args[0]);
            }
            throw new JSONException("Unsupported type");
        }
        JSONArray array = new JSONArray();
        this.stack.push(array);
        for (int i = 0; i < args.length; ++i) {
            if (args[i] instanceof Closure) {
                this.append(name, this.createObject((Closure)args[i]));
                continue;
            }
            if (args[i] instanceof Map) {
                this.append(name, this.createObject((Map)args[i]));
                continue;
            }
            if (args[i] instanceof List) {
                this.append(name, this.createArray((List)args[i]));
                continue;
            }
            this._append(name, args[i], (JSON)this.stack.peek());
        }
        this.stack.pop();
        return array;
    }
}

