/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.net.sf.ezmorph.object;

import com.alibaba.schedulerx.shade.net.sf.ezmorph.MorphException;
import com.alibaba.schedulerx.shade.net.sf.ezmorph.object.AbstractObjectMorpher;
import com.alibaba.schedulerx.shade.org.apache.commons.lang.builder.EqualsBuilder;
import com.alibaba.schedulerx.shade.org.apache.commons.lang.builder.HashCodeBuilder;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Locale;

public final class BigIntegerMorpher
extends AbstractObjectMorpher {
    private BigInteger defaultValue;
    static /* synthetic */ Class class$0;

    public BigIntegerMorpher() {
    }

    public BigIntegerMorpher(BigInteger defaultValue) {
        super(true);
        this.defaultValue = defaultValue;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BigIntegerMorpher)) {
            return false;
        }
        BigIntegerMorpher other = (BigIntegerMorpher)obj;
        EqualsBuilder builder = new EqualsBuilder();
        if (this.isUseDefault() && other.isUseDefault()) {
            builder.append(this.getDefaultValue(), other.getDefaultValue());
            return builder.isEquals();
        }
        if (!this.isUseDefault() && !other.isUseDefault()) {
            return builder.isEquals();
        }
        return false;
    }

    public BigInteger getDefaultValue() {
        return this.defaultValue;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        if (this.isUseDefault()) {
            builder.append(this.getDefaultValue());
        }
        return builder.toHashCode();
    }

    public Object morph(Object value2) {
        if (value2 instanceof BigInteger) {
            return value2;
        }
        if (value2 == null) {
            if (this.isUseDefault()) {
                return this.defaultValue;
            }
            return null;
        }
        if (value2 instanceof Number) {
            if (value2 instanceof Float) {
                Float f = (Float)value2;
                if (f.isInfinite() || f.isNaN()) {
                    throw new MorphException("BigInteger can not be infinite or NaN");
                }
            } else if (value2 instanceof Double) {
                Double d = (Double)value2;
                if (d.isInfinite() || d.isNaN()) {
                    throw new MorphException("BigInteger can not be infinite or NaN");
                }
            } else if (value2 instanceof BigDecimal) {
                return ((BigDecimal)value2).toBigInteger();
            }
            return BigInteger.valueOf(((Number)value2).longValue());
        }
        try {
            String str = this.getIntegerValue(value2);
            if (str.length() == 0 || str.equalsIgnoreCase("null")) {
                return null;
            }
            return new BigInteger(str);
        }
        catch (NumberFormatException nfe) {
            if (this.isUseDefault()) {
                return this.defaultValue;
            }
            throw new MorphException(nfe);
        }
    }

    public Class morphsTo() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.math.BigInteger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    protected String getIntegerValue(Object obj) {
        Locale defaultLocale = Locale.getDefault();
        String str = null;
        try {
            Locale.setDefault(Locale.US);
            str = String.valueOf(obj).trim();
        }
        finally {
            Locale.setDefault(defaultLocale);
        }
        int index2 = str.indexOf(".");
        if (index2 != -1) {
            str = str.substring(0, index2);
        }
        return str;
    }
}

