/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.javassist;

import com.alibaba.schedulerx.shade.javassist.CannotCompileException;
import com.alibaba.schedulerx.shade.javassist.ClassClassPath;
import com.alibaba.schedulerx.shade.javassist.ClassPath;
import com.alibaba.schedulerx.shade.javassist.ClassPathList;
import com.alibaba.schedulerx.shade.javassist.DirClassPath;
import com.alibaba.schedulerx.shade.javassist.JarClassPath;
import com.alibaba.schedulerx.shade.javassist.JarDirClassPath;
import com.alibaba.schedulerx.shade.javassist.NotFoundException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;

final class ClassPoolTail {
    protected ClassPathList pathList = null;

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[class path: ");
        ClassPathList list = this.pathList;
        while (list != null) {
            buf.append(list.path.toString());
            buf.append(File.pathSeparatorChar);
            list = list.next;
        }
        buf.append(']');
        return buf.toString();
    }

    public synchronized ClassPath insertClassPath(ClassPath cp) {
        this.pathList = new ClassPathList(cp, this.pathList);
        return cp;
    }

    public synchronized ClassPath appendClassPath(ClassPath cp) {
        ClassPathList tail = new ClassPathList(cp, null);
        ClassPathList list = this.pathList;
        if (list == null) {
            this.pathList = tail;
        } else {
            while (list.next != null) {
                list = list.next;
            }
            list.next = tail;
        }
        return cp;
    }

    public synchronized void removeClassPath(ClassPath cp) {
        ClassPathList list = this.pathList;
        if (list != null) {
            if (list.path == cp) {
                this.pathList = list.next;
            } else {
                while (list.next != null) {
                    if (list.next.path == cp) {
                        list.next = list.next.next;
                        continue;
                    }
                    list = list.next;
                }
            }
        }
        cp.close();
    }

    public ClassPath appendSystemPath() {
        return this.appendClassPath(new ClassClassPath());
    }

    public ClassPath insertClassPath(String pathname) throws NotFoundException {
        return this.insertClassPath(ClassPoolTail.makePathObject(pathname));
    }

    public ClassPath appendClassPath(String pathname) throws NotFoundException {
        return this.appendClassPath(ClassPoolTail.makePathObject(pathname));
    }

    private static ClassPath makePathObject(String pathname) throws NotFoundException {
        String lower = pathname.toLowerCase();
        if (lower.endsWith(".jar") || lower.endsWith(".zip")) {
            return new JarClassPath(pathname);
        }
        int len2 = pathname.length();
        if (len2 > 2 && pathname.charAt(len2 - 1) == '*' && (pathname.charAt(len2 - 2) == '/' || pathname.charAt(len2 - 2) == File.separatorChar)) {
            String dir = pathname.substring(0, len2 - 2);
            return new JarDirClassPath(dir);
        }
        return new DirClassPath(pathname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeClassfile(String classname, OutputStream out) throws NotFoundException, IOException, CannotCompileException {
        InputStream fin = this.openClassfile(classname);
        if (fin == null) {
            throw new NotFoundException(classname);
        }
        try {
            ClassPoolTail.copyStream(fin, out);
        }
        finally {
            fin.close();
        }
    }

    InputStream openClassfile(String classname) throws NotFoundException {
        ClassPathList list = this.pathList;
        InputStream ins2 = null;
        NotFoundException error = null;
        while (list != null) {
            block5: {
                try {
                    ins2 = list.path.openClassfile(classname);
                }
                catch (NotFoundException e) {
                    if (error != null) break block5;
                    error = e;
                }
            }
            if (ins2 == null) {
                list = list.next;
                continue;
            }
            return ins2;
        }
        if (error != null) {
            throw error;
        }
        return null;
    }

    public URL find(String classname) {
        ClassPathList list = this.pathList;
        URL url = null;
        while (list != null) {
            url = list.path.find(classname);
            if (url == null) {
                list = list.next;
                continue;
            }
            return url;
        }
        return null;
    }

    public static byte[] readStream(InputStream fin) throws IOException {
        byte[][] bufs = new byte[8][];
        int bufsize = 4096;
        for (int i = 0; i < 8; ++i) {
            bufs[i] = new byte[bufsize];
            int size2 = 0;
            int len2 = 0;
            do {
                if ((len2 = fin.read(bufs[i], size2, bufsize - size2)) >= 0) continue;
                byte[] result2 = new byte[bufsize - 4096 + size2];
                int s2 = 0;
                for (int j = 0; j < i; ++j) {
                    System.arraycopy(bufs[j], 0, result2, s2, s2 + 4096);
                    s2 = s2 + s2 + 4096;
                }
                System.arraycopy(bufs[i], 0, result2, s2, size2);
                return result2;
            } while ((size2 += len2) < bufsize);
            bufsize *= 2;
        }
        throw new IOException("too much data");
    }

    public static void copyStream(InputStream fin, OutputStream fout) throws IOException {
        int bufsize = 4096;
        byte[] buf = null;
        for (int i = 0; i < 64; ++i) {
            if (i < 8) {
                buf = new byte[bufsize *= 2];
            }
            int size2 = 0;
            int len2 = 0;
            do {
                if ((len2 = fin.read(buf, size2, bufsize - size2)) >= 0) continue;
                fout.write(buf, 0, size2);
                return;
            } while ((size2 += len2) < bufsize);
            fout.write(buf);
        }
        throw new IOException("too much data");
    }
}

