/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.zaxxer.hikari.pool;

import com.alibaba.schedulerx.shade.com.zaxxer.hikari.pool.BaseHikariPool;
import com.alibaba.schedulerx.shade.com.zaxxer.hikari.util.IConcurrentBagEntry;
import java.sql.Connection;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class PoolBagEntry
implements IConcurrentBagEntry {
    public final AtomicInteger state = new AtomicInteger();
    public Connection connection;
    public long lastAccess;
    public long lastOpenTime;
    public volatile boolean evicted;
    public volatile boolean aborted;
    private volatile ScheduledFuture<?> endOfLife;

    public PoolBagEntry(Connection connection, final BaseHikariPool pool) {
        this.connection = connection;
        this.lastAccess = System.currentTimeMillis();
        long maxLifetime = pool.configuration.getMaxLifetime();
        if (maxLifetime > 0L) {
            this.endOfLife = pool.houseKeepingExecutorService.schedule(new Runnable(){

                @Override
                public void run() {
                    if (pool.connectionBag.reserve(PoolBagEntry.this)) {
                        pool.closeConnection(PoolBagEntry.this);
                    } else {
                        PoolBagEntry.this.evicted = true;
                    }
                }
            }, maxLifetime, TimeUnit.MILLISECONDS);
        }
    }

    void cancelMaxLifeTermination() {
        if (this.endOfLife != null) {
            this.endOfLife.cancel(false);
        }
    }

    @Override
    public AtomicInteger state() {
        return this.state;
    }

    public String toString() {
        return "Connection......" + this.connection + "\n" + "  Last  access.." + this.lastAccess + "\n" + "  Last open....." + this.lastOpenTime + "\n" + "  State........." + this.stateToString();
    }

    private String stateToString() {
        switch (this.state.get()) {
            case 1: {
                return "IN_USE";
            }
            case 0: {
                return "NOT_IN_USE";
            }
            case -1: {
                return "REMOVED";
            }
            case -2: {
                return "RESERVED";
            }
        }
        return "Invalid";
    }
}

