/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.zaxxer.hikari.metrics;

import com.alibaba.schedulerx.shade.com.zaxxer.hikari.HikariConfig;
import com.alibaba.schedulerx.shade.com.zaxxer.hikari.pool.BaseHikariPool;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;

public final class CodahaleHealthChecker {
    public static void registerHealthChecks(BaseHikariPool pool, HealthCheckRegistry registry) {
        SortedMap timers;
        final HikariConfig hikariConfig = pool.getConfiguration();
        Properties healthCheckProperties = hikariConfig.getHealthCheckProperties();
        MetricRegistry metricRegistry = (MetricRegistry)hikariConfig.getMetricRegistry();
        long checkTimeoutMs = Long.parseLong(healthCheckProperties.getProperty("connectivityCheckTimeoutMs", String.valueOf(hikariConfig.getConnectionTimeout())));
        registry.register(MetricRegistry.name((String)hikariConfig.getPoolName(), (String[])new String[]{"pool", "ConnectivityCheck"}), (HealthCheck)new ConnectivityHealthCheck(pool, checkTimeoutMs));
        long expected99thPercentile = Long.parseLong(healthCheckProperties.getProperty("expected99thPercentileMs", "0"));
        if (metricRegistry != null && expected99thPercentile > 0L && !(timers = metricRegistry.getTimers(new MetricFilter(){

            public boolean matches(String name, Metric metric) {
                return name.equals(MetricRegistry.name((String)hikariConfig.getPoolName(), (String[])new String[]{"pool", "Wait"}));
            }
        })).isEmpty()) {
            Timer timer = (Timer)timers.entrySet().iterator().next().getValue();
            registry.register(MetricRegistry.name((String)hikariConfig.getPoolName(), (String[])new String[]{"pool", "Connection99Percent"}), (HealthCheck)new Connection99Percent(timer, expected99thPercentile));
        }
    }

    private CodahaleHealthChecker() {
    }

    private static class Connection99Percent
    extends HealthCheck {
        private final Timer waitTimer;
        private final long expected99thPercentile;

        Connection99Percent(Timer waitTimer, long expected99thPercentile) {
            this.waitTimer = waitTimer;
            this.expected99thPercentile = expected99thPercentile;
        }

        protected HealthCheck.Result check() throws Exception {
            long the99thPercentile = TimeUnit.NANOSECONDS.toMillis(Math.round(this.waitTimer.getSnapshot().get99thPercentile()));
            return the99thPercentile <= this.expected99thPercentile ? HealthCheck.Result.healthy() : HealthCheck.Result.unhealthy((String)"99th percentile connection wait time of %dms exceeds the threshold %dms", (Object[])new Object[]{the99thPercentile, this.expected99thPercentile});
        }
    }

    private static class ConnectivityHealthCheck
    extends HealthCheck {
        private final BaseHikariPool pool;
        private final long checkTimeoutMs;

        ConnectivityHealthCheck(BaseHikariPool pool, long checkTimeoutMs) {
            this.pool = pool;
            this.checkTimeoutMs = checkTimeoutMs > 0L && checkTimeoutMs != Integer.MAX_VALUE ? checkTimeoutMs : TimeUnit.SECONDS.toMillis(10L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected HealthCheck.Result check() throws Exception {
            Connection connection = null;
            try {
                connection = this.pool.getConnection(this.checkTimeoutMs);
                HealthCheck.Result result2 = HealthCheck.Result.healthy();
                return result2;
            }
            catch (SQLException e) {
                HealthCheck.Result result3 = HealthCheck.Result.unhealthy((Throwable)e);
                return result3;
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
    }
}

