/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.zaxxer.hikari;

import com.alibaba.schedulerx.shade.com.zaxxer.hikari.HikariConfig;
import com.alibaba.schedulerx.shade.com.zaxxer.hikari.pool.HikariPool;
import com.alibaba.schedulerx.shade.com.zaxxer.hikari.proxy.IHikariConnectionProxy;
import com.alibaba.schedulerx.shade.com.zaxxer.hikari.util.DriverDataSource;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheckRegistry;
import java.io.Closeable;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Wrapper;
import java.util.HashMap;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HikariDataSource
extends HikariConfig
implements DataSource,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(HikariDataSource.class);
    private final HashMap<MultiPoolKey, HikariPool> multiPool;
    private volatile boolean isShutdown;
    private final HikariPool fastPathPool;
    private volatile HikariPool pool;

    public HikariDataSource() {
        this.fastPathPool = null;
        this.multiPool = new HashMap();
    }

    public HikariDataSource(HikariConfig configuration) {
        configuration.validate();
        configuration.copyState(this);
        this.multiPool = new HashMap();
        LOGGER.info("HikariCP pool {} is starting.", (Object)configuration.getPoolName());
        this.pool = this.fastPathPool = new HikariPool(this);
        this.multiPool.put(new MultiPoolKey(this.getUsername(), this.getPassword()), this.pool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() throws SQLException {
        if (this.isShutdown) {
            throw new SQLException("Pool has been shutdown");
        }
        if (this.fastPathPool != null) {
            return this.fastPathPool.getConnection();
        }
        HikariPool result2 = this.pool;
        if (result2 == null) {
            HikariDataSource hikariDataSource = this;
            synchronized (hikariDataSource) {
                result2 = this.pool;
                if (result2 == null) {
                    this.validate();
                    LOGGER.info("HikariCP pool {} is starting.", (Object)this.getPoolName());
                    this.pool = result2 = new HikariPool(this);
                    this.multiPool.put(new MultiPoolKey(this.getUsername(), this.getPassword()), this.pool);
                }
            }
        }
        return result2.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Connection getConnection(String username, String password) throws SQLException {
        HikariPool hikariPool;
        if (this.isShutdown) {
            throw new SQLException("Pool has been shutdown");
        }
        MultiPoolKey key = new MultiPoolKey(username, password);
        HashMap<MultiPoolKey, HikariPool> hashMap = this.multiPool;
        synchronized (hashMap) {
            hikariPool = this.multiPool.get(key);
            if (hikariPool == null) {
                hikariPool = new HikariPool(this, username, password);
                this.multiPool.put(key, hikariPool);
            }
        }
        return hikariPool.getConnection();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.pool.getDataSource() != null ? this.pool.getDataSource().getLogWriter() : null;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        if (this.pool.getDataSource() != null) {
            this.pool.getDataSource().setLogWriter(out);
        }
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        for (HikariPool hikariPool : this.multiPool.values()) {
            hikariPool.getDataSource().setLoginTimeout(seconds);
        }
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        HikariPool hikariPool = this.multiPool.values().iterator().next();
        if (hikariPool != null) {
            return hikariPool.getDataSource().getLoginTimeout();
        }
        return 0;
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return (T)this;
        }
        if (this.pool != null) {
            if (iface.isInstance(this.pool.getDataSource())) {
                return (T)this.pool.getDataSource();
            }
            if (this.pool.getDataSource() instanceof Wrapper) {
                return this.pool.getDataSource().unwrap(iface);
            }
        }
        throw new SQLException("Wrapped DataSource is not an instance of " + iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return true;
        }
        if (this.pool != null) {
            if (iface.isInstance(this.pool.getDataSource())) {
                return true;
            }
            if (this.pool.getDataSource() instanceof Wrapper) {
                return this.pool.getDataSource().isWrapperFor(iface);
            }
        }
        return false;
    }

    @Override
    public void setMetricRegistry(Object metricRegistry) {
        boolean isAlreadySet = this.getMetricRegistry() != null;
        super.setMetricRegistry(metricRegistry);
        if (this.fastPathPool != null || this.pool != null) {
            if (isAlreadySet) {
                throw new IllegalStateException("MetricRegistry can only be set one time");
            }
            this.pool.setMetricRegistry((MetricRegistry)super.getMetricRegistry());
        }
    }

    @Override
    public void setHealthCheckRegistry(Object healthCheckRegistry) {
        boolean isAlreadySet = this.getHealthCheckRegistry() != null;
        super.setHealthCheckRegistry(healthCheckRegistry);
        if (this.fastPathPool != null || this.pool != null) {
            if (isAlreadySet) {
                throw new IllegalStateException("HealthCheckRegistry can only be set one time");
            }
            this.pool.setHealthCheckRegistry((HealthCheckRegistry)super.getHealthCheckRegistry());
        }
    }

    public void evictConnection(Connection connection) {
        if (!this.isShutdown && this.pool != null && connection instanceof IHikariConnectionProxy) {
            this.pool.evictConnection((IHikariConnectionProxy)connection);
        }
    }

    public void suspendPool() {
        if (!this.isShutdown && this.pool != null) {
            this.pool.suspendPool();
        }
    }

    public void resumePool() {
        if (!this.isShutdown && this.pool != null) {
            this.pool.resumePool();
        }
    }

    @Override
    public void close() {
        this.shutdown();
    }

    public void shutdown() {
        if (this.isShutdown) {
            return;
        }
        this.isShutdown = true;
        if (this.fastPathPool != null) {
            this.shutdownHelper(this.fastPathPool);
        }
        for (HikariPool hikariPool : this.multiPool.values()) {
            this.shutdownHelper(hikariPool);
        }
    }

    public String toString() {
        return String.format("HikariDataSource (%s)", this.pool);
    }

    private void shutdownHelper(HikariPool hPool) {
        try {
            hPool.shutdown();
        }
        catch (InterruptedException e) {
            LoggerFactory.getLogger(this.getClass()).warn("Interrupted during shutdown", e);
        }
        if (hPool.getDataSource() instanceof DriverDataSource) {
            ((DriverDataSource)hPool.getDataSource()).shutdown();
        }
    }

    private static class MultiPoolKey {
        private String username;
        private String password;

        MultiPoolKey(String username, String password) {
            this.username = username;
            this.password = password;
        }

        public int hashCode() {
            return this.password == null ? 0 : this.password.hashCode();
        }

        public boolean equals(Object obj) {
            MultiPoolKey otherKey = (MultiPoolKey)obj;
            if (this.username != null && !this.username.equals(otherKey.username)) {
                return false;
            }
            if (this.username == null && otherKey.username != null) {
                return false;
            }
            if (this.password != null && !this.password.equals(otherKey.password)) {
                return false;
            }
            return this.password != null || otherKey.password == null;
        }
    }
}

