/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.taobao.spas.sdk.common.utils;

import com.alibaba.schedulerx.shade.com.taobao.spas.sdk.common.utils.SpasHttpUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpasHttpClient {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResult httpPostJson(String url, Map<String, String> properties, String content, String charset) throws IOException {
        HttpURLConnection conn = null;
        BufferedReader reader = null;
        try {
            if (url.startsWith("https://")) {
                SSLSocketFactory ssf = SpasHttpUtils.getSSLSocketFactory();
                HttpsURLConnection httpsConn = (HttpsURLConnection)new URL(url).openConnection();
                httpsConn.setSSLSocketFactory(ssf);
                conn = httpsConn;
            } else {
                conn = (HttpURLConnection)new URL(url).openConnection();
            }
            conn.setRequestMethod("POST");
            conn.setConnectTimeout(SpasHttpUtils.getConnTimeout());
            conn.setReadTimeout(SpasHttpUtils.getReadTimeout());
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setUseCaches(false);
            conn.setInstanceFollowRedirects(true);
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("Accept", "application/json");
            if (properties != null) {
                for (Map.Entry<String, String> entry : properties.entrySet()) {
                    conn.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            OutputStream out = conn.getOutputStream();
            out.write(content.getBytes());
            out.flush();
            int respCode = conn.getResponseCode();
            InputStream in2 = respCode >= 200 && respCode < 300 ? conn.getInputStream() : conn.getErrorStream();
            StringBuilder sb = new StringBuilder("");
            if (in2 != null) {
                String line;
                reader = new BufferedReader(new InputStreamReader(in2, charset));
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                }
            }
            HttpResult httpResult = new HttpResult(respCode, sb.toString());
            return httpResult;
        }
        finally {
            if (null != reader) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
            if (null != conn) {
                conn.disconnect();
            }
        }
    }

    public static class HttpResult {
        public final int code;
        public final String content;

        public HttpResult(int code, String content) {
            this.code = code;
            this.content = content;
        }
    }
}

