/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.taobao.spas.sdk.common.param;

import com.alibaba.schedulerx.shade.com.taobao.spas.sdk.common.param.ParamNode;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortedParamList
extends ArrayList<ParamNode> {
    private static final long serialVersionUID = 1L;

    @Override
    public boolean add(ParamNode e) {
        if (this.size() == 0) {
            return super.add(e);
        }
        return this.binaryAdd(e, 0, this.size() - 1);
    }

    private boolean binaryAdd(ParamNode e, int start2, int end) {
        if (start2 > end) {
            super.add(start2, e);
            return true;
        }
        if (start2 == end) {
            if (e.compareTo((ParamNode)this.get(start2)) <= 0) {
                super.add(start2, e);
            } else {
                super.add(start2 + 1, e);
            }
            return true;
        }
        int mid = (start2 + end) / 2;
        int cmp = e.compareTo((ParamNode)this.get(mid));
        if (cmp < 0) {
            return this.binaryAdd(e, start2, mid - 1);
        }
        if (cmp > 0) {
            return this.binaryAdd(e, mid + 1, end);
        }
        super.add(mid, e);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends ParamNode> c) {
        for (ParamNode paramNode : c) {
            this.add(paramNode);
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.size() > 0) {
            sb.append(((ParamNode)this.get(0)).toString());
        }
        for (int i = 1; i < this.size(); ++i) {
            sb.append("&" + ((ParamNode)this.get(i)).toString());
        }
        return sb.toString();
    }

    public String toRawString() {
        StringBuilder sb = new StringBuilder();
        for (ParamNode e : this) {
            sb.append(e.toRawString());
        }
        return sb.toString();
    }
}

