/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.taobao.spas.sdk.common.cache;

import com.alibaba.schedulerx.shade.com.taobao.spas.sdk.common.cache.BatchRefresher;
import com.alibaba.schedulerx.shade.com.taobao.spas.sdk.common.cache.Refresher;
import com.alibaba.schedulerx.shade.com.taobao.spas.sdk.common.log.SpasLogCode;
import com.alibaba.schedulerx.shade.com.taobao.spas.sdk.common.log.SpasLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentLRUCache<K, V> {
    private Map<K, CacheValue<V>> cache = new ConcurrentHashMap<K, CacheValue<V>>();
    private int cacheSize;
    private TimerTask watcher;
    private Refresher<K, V> refresher;
    private BatchRefresher<K, V> batchRefresher;
    private long expire;

    public ConcurrentLRUCache(int size2) {
        this.init(size2, 10L);
    }

    public ConcurrentLRUCache(int size2, long refresh) {
        this.init(size2, refresh);
    }

    public ConcurrentLRUCache(long refresh, long timeout, Refresher refresher) {
        this.expire = timeout * 1000L;
        this.refresher = refresher;
        this.init(Integer.MAX_VALUE, refresh);
    }

    public ConcurrentLRUCache(long refresh, long timeout, BatchRefresher refresher) {
        this.expire = timeout * 1000L;
        this.batchRefresher = refresher;
        this.init(Integer.MAX_VALUE, refresh);
    }

    public ConcurrentLRUCache(int size2, long refresh, long timeout, Refresher refresher) {
        this.expire = timeout * 1000L;
        this.refresher = refresher;
        this.init(size2, refresh);
    }

    public ConcurrentLRUCache(int size2, long refresh, long timeout, BatchRefresher refresher) {
        this.expire = timeout * 1000L;
        this.batchRefresher = refresher;
        this.init(size2, refresh);
    }

    private void init(int size2, long refresh) {
        this.cacheSize = size2;
        final long interval = refresh * 1000L;
        this.watcher = new TimerTask(){
            private Timer timer = new Timer(true);
            {
                this.timer.schedule((TimerTask)this, interval, interval);
            }

            public void run() {
                try {
                    int overflow = ConcurrentLRUCache.this.cache.size() - ConcurrentLRUCache.this.cacheSize;
                    if (overflow > 0) {
                        ArrayList sortList = new ArrayList(ConcurrentLRUCache.this.cache.entrySet());
                        Collections.sort(sortList, new Comparator<Map.Entry<K, CacheValue<V>>>(){

                            @Override
                            public int compare(Map.Entry<K, CacheValue<V>> o1, Map.Entry<K, CacheValue<V>> o2) {
                                if (o1 == o2) {
                                    return 0;
                                }
                                return (int)(o1.getValue().accessTime - o2.getValue().accessTime);
                            }
                        });
                        for (Map.Entry entry : sortList) {
                            if (overflow-- <= 0) break;
                            ConcurrentLRUCache.this.cache.remove(entry.getKey());
                        }
                    }
                    if (ConcurrentLRUCache.this.refresher != null) {
                        for (Map.Entry entry : ConcurrentLRUCache.this.cache.entrySet()) {
                            if (((CacheValue)entry.getValue()).updateTime + ConcurrentLRUCache.this.expire >= System.currentTimeMillis()) continue;
                            Object v = ConcurrentLRUCache.this.refresher.refresh(entry.getKey(), ((CacheValue)entry.getValue()).value);
                            if (v != null) {
                                ((CacheValue)entry.getValue()).update(v);
                                continue;
                            }
                            ConcurrentLRUCache.this.cache.remove(entry.getKey());
                        }
                    }
                    if (ConcurrentLRUCache.this.batchRefresher != null) {
                        int batchLimit = ConcurrentLRUCache.this.batchRefresher.getBatchLimit();
                        HashMap batch2 = new HashMap();
                        for (Map.Entry entry : ConcurrentLRUCache.this.cache.entrySet()) {
                            if (((CacheValue)entry.getValue()).updateTime + ConcurrentLRUCache.this.expire >= System.currentTimeMillis()) continue;
                            batch2.put(entry.getKey(), ((CacheValue)entry.getValue()).value);
                            if (batch2.size() < batchLimit) continue;
                            ConcurrentLRUCache.this.refreshBatch(batch2);
                            batch2.clear();
                        }
                        if (!batch2.isEmpty()) {
                            ConcurrentLRUCache.this.refreshBatch(batch2);
                        }
                    }
                }
                catch (Exception e) {
                    SpasLogger.error(SpasLogCode.SPAS0115, "LRUCache failed to clean old item", (Throwable)e);
                }
            }
        };
    }

    private void refreshBatch(Map<K, V> batch2) {
        Map<K, V> retains = this.batchRefresher.batchRefresh(batch2);
        for (Map.Entry<K, V> entry : retains.entrySet()) {
            CacheValue<V> item = this.cache.get(entry.getKey());
            if (item == null) continue;
            item.update(entry.getValue());
        }
        if (retains.size() < batch2.size()) {
            HashSet<K> removeKeys = new HashSet<K>(batch2.keySet());
            removeKeys.removeAll(retains.keySet());
            for (Object key : removeKeys) {
                this.cache.remove(key);
            }
        }
    }

    public V get(K key) {
        CacheValue<V> wrapper = this.cache.get(key);
        if (wrapper != null) {
            wrapper.refresh();
            return wrapper.value;
        }
        return null;
    }

    public void put(K key, V value2) {
        this.cache.put(key, new CacheValue<V>(value2));
    }

    public V remove(K key) {
        CacheValue<V> wrapper = this.cache.remove(key);
        if (wrapper != null) {
            return wrapper.value;
        }
        return null;
    }

    public void clear() {
        this.cache.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CacheValue<V> {
        V value;
        long accessTime;
        long updateTime;

        CacheValue(V value2) {
            this.value = value2;
            this.accessTime = this.updateTime = System.currentTimeMillis();
        }

        public void refresh() {
            this.accessTime = System.currentTimeMillis();
        }

        public void update(V value2) {
            this.value = value2;
            this.updateTime = System.currentTimeMillis();
        }
    }
}

