/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.aliyun.openservices.log.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.internal.Unmarshaller;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.util.Utils;
import com.alibaba.schedulerx.shade.net.sf.json.JSONArray;
import com.alibaba.schedulerx.shade.net.sf.json.JSONException;
import com.alibaba.schedulerx.shade.net.sf.json.JSONObject;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public final class JsonUtils {
    private static final SerializeConfig SERIALIZE_CONFIG = new SerializeConfig();

    private JsonUtils() {
    }

    public static String serialize(Object object) {
        return JSON.toJSONString((Object)object, (SerializeConfig)SERIALIZE_CONFIG, (SerializerFeature[])new SerializerFeature[0]);
    }

    public static <T> List<T> readList(JSONObject value2, String key, Unmarshaller<T> unmarshaller) {
        return JsonUtils.readList(value2.getJSONArray(key), unmarshaller);
    }

    public static <T> List<T> readList(JSONArray list, Unmarshaller<T> unmarshaller) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> values2 = new ArrayList<T>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            values2.add(unmarshaller.unmarshal(list, i));
        }
        return values2;
    }

    public static List<String> readOptionalStrings(JSONObject object, String key) {
        if (!object.has(key)) {
            return Collections.emptyList();
        }
        try {
            return JsonUtils.readStringList(object, key);
        }
        catch (JSONException ex) {
            return Collections.emptyList();
        }
    }

    public static List<String> readStringList(JSONObject object, String key) {
        return JsonUtils.readList(object, key, new Unmarshaller<String>(){

            @Override
            public String unmarshal(JSONArray value2, int index2) {
                return value2.getString(index2);
            }
        });
    }

    public static String readOptionalString(JSONObject object, String key) {
        return object.has(key) ? object.getString(key) : null;
    }

    public static boolean readBool(JSONObject object, String key, boolean defaultValue) {
        return object.has(key) ? object.getBoolean(key) : defaultValue;
    }

    public static Integer readOptionalInt(JSONObject object, String key) {
        return object.has(key) ? Integer.valueOf(object.getInt(key)) : null;
    }

    static {
        SERIALIZE_CONFIG.put(Date.class, (ObjectSerializer)new DateToUnixTimestampSerializer());
    }

    private static class DateToUnixTimestampSerializer
    implements ObjectSerializer {
        private DateToUnixTimestampSerializer() {
        }

        public void write(JSONSerializer serializer, Object date, Object fieldName, Type fieldType, int features) {
            if (date != null) {
                serializer.write((Object)Utils.dateToTimestamp((Date)date));
            }
        }
    }
}

