/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.aliyun.openservices.log.http.comm;

import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.http.client.ClientConfiguration;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.http.client.ClientException;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.http.client.HttpMethod;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.http.client.ServiceException;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.http.comm.HttpMessage;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.http.comm.RequestMessage;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.http.comm.ResponseMessage;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.http.utils.HttpUtil;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.util.Args;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public abstract class ServiceClient {
    private static final int DEFAULT_MARK_LIMIT = 4096;
    protected ClientConfiguration config;

    protected ServiceClient(ClientConfiguration config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseMessage sendRequest(RequestMessage request2, String charset) throws ServiceException, ClientException {
        Args.notNull(request2, "request");
        Args.notNullOrEmpty(charset, "charset");
        try {
            ResponseMessage responseMessage = this.sendRequestImpl(request2, charset);
            return responseMessage;
        }
        finally {
            try {
                request2.close();
            }
            catch (IOException iOException) {}
        }
    }

    private ResponseMessage sendRequestImpl(RequestMessage request2, String charset) throws ClientException, ServiceException {
        InputStream content = request2.getContent();
        if (content != null && content.markSupported()) {
            content.mark(4096);
        }
        try {
            Request httpRequest = this.buildRequest(request2, charset);
            return this.sendRequestCore(httpRequest, charset);
        }
        catch (ServiceException ex) {
            throw ex;
        }
        catch (ClientException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ClientException(ex.getMessage(), ex);
        }
    }

    protected abstract ResponseMessage sendRequestCore(Request var1, String var2) throws Exception;

    private Request buildRequest(RequestMessage requestMessage, String charset) throws ClientException {
        boolean putParamsInUri;
        String paramString;
        Request request2 = new Request();
        request2.setMethod(requestMessage.getMethod());
        request2.setHeaders(requestMessage.getHeaders());
        if (request2.getHeaders() != null) {
            HttpUtil.convertHeaderCharsetToIso88591(request2.getHeaders());
        }
        String delimiter = "/";
        String uri = requestMessage.getEndpoint().toString();
        if (!(uri.endsWith("/") || requestMessage.getResourcePath() != null && requestMessage.getResourcePath().startsWith("/"))) {
            uri = uri + "/";
        }
        if (requestMessage.getResourcePath() != null) {
            uri = uri + requestMessage.getResourcePath();
        }
        try {
            paramString = HttpUtil.paramToQueryString(requestMessage.getParameters(), charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)("EncodingFailed" + e.getMessage()));
        }
        boolean requestHasNoPayload = requestMessage.getContent() != null;
        boolean requestIsPost = requestMessage.getMethod() == HttpMethod.POST;
        boolean bl = putParamsInUri = !requestIsPost || requestHasNoPayload;
        if (paramString != null && putParamsInUri) {
            uri = uri + "?" + paramString;
        }
        request2.setUrl(uri);
        if (requestIsPost && requestMessage.getContent() == null && paramString != null) {
            try {
                byte[] buf = paramString.getBytes(charset);
                ByteArrayInputStream content = new ByteArrayInputStream(buf);
                request2.setContent(content);
                request2.setContentLength(buf.length);
            }
            catch (UnsupportedEncodingException e) {
                throw new AssertionError((Object)("EncodingFailed" + e.getMessage()));
            }
        } else {
            request2.setContent(requestMessage.getContent());
            request2.setContentLength(requestMessage.getContentLength());
        }
        return request2;
    }

    public static class Request
    extends HttpMessage {
        private String uri;
        private HttpMethod method;

        public String getUri() {
            return this.uri;
        }

        public void setUrl(String uri) {
            this.uri = uri;
        }

        public HttpMethod getMethod() {
            return this.method;
        }

        public void setMethod(HttpMethod method) {
            this.method = method;
        }
    }
}

