/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.IndexKey;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.exception.LogException;
import java.util.HashMap;
import java.util.Map;

public class IndexKeys {
    private Map<String, IndexKey> keys = new HashMap<String, IndexKey>();

    public IndexKeys() {
    }

    public IndexKeys(IndexKeys other) {
        this.keys = new HashMap<String, IndexKey>();
        for (Map.Entry<String, IndexKey> entry : other.GetKeys().entrySet()) {
            this.keys.put(entry.getKey(), new IndexKey(entry.getValue()));
        }
    }

    public Map<String, IndexKey> GetKeys() {
        return this.keys;
    }

    public void AddKey(String key, IndexKey keyContent) {
        this.keys.put(key, keyContent);
    }

    public JSONObject ToRequestJson() throws LogException {
        JSONObject keysDict = new JSONObject();
        for (Map.Entry<String, IndexKey> entry : this.keys.entrySet()) {
            keysDict.put(entry.getKey(), (Object)entry.getValue().ToRequestJson());
        }
        return keysDict;
    }

    public String ToRequestString() throws LogException {
        return this.ToRequestJson().toString();
    }

    public JSONObject ToJsonObject() throws LogException {
        JSONObject keysDict = this.ToRequestJson();
        return keysDict;
    }

    public String ToJsonString() throws LogException {
        return this.ToJsonObject().toString();
    }

    public void FromJsonObject(JSONObject dict) throws LogException {
        try {
            this.keys = new HashMap<String, IndexKey>();
            for (String key : dict.keySet()) {
                JSONObject value2 = dict.getJSONObject(key);
                IndexKey indexKey = new IndexKey();
                indexKey.FromJsonObject(value2);
                this.AddKey(key, indexKey);
            }
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateIndexKeys", e.getMessage(), e, "");
        }
    }

    public void FromJsonString(String indexKeysString) throws LogException {
        try {
            JSONObject dict = JSONObject.parseObject((String)indexKeysString);
            this.FromJsonObject(dict);
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateIndexKeys", e.getMessage(), e, "");
        }
    }
}

