/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common;

import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.ApsaraLogConfigInputDetail;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.ConfigInputDetail;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.DelimiterConfigInputDetail;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.JsonConfigInputDetail;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.PluginLogConfigInputDetail;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.SensitiveKey;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.StreamLogConfigInputDetail;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.exception.LogException;
import com.alibaba.schedulerx.shade.net.sf.json.JSONArray;
import com.alibaba.schedulerx.shade.net.sf.json.JSONException;
import com.alibaba.schedulerx.shade.net.sf.json.JSONObject;
import java.util.ArrayList;
import java.util.List;

public abstract class CommonConfigInputDetail {
    protected boolean localStorage = true;
    protected ArrayList<String> filterRegex = new ArrayList();
    protected ArrayList<String> filterKey = new ArrayList();
    protected ArrayList<String> shardHashKey = new ArrayList();
    protected boolean enableTag = false;
    protected boolean enableRawLog = false;
    protected int maxSendRate = -1;
    protected int sendRateExpire = 0;
    protected ArrayList<SensitiveKey> sensitiveKeys = new ArrayList();
    protected String mergeType;
    protected long delayAlarmBytes = 0L;
    protected boolean adjustTimezone = false;
    protected String logTimezone = "";
    protected int priority = 0;

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public boolean isAdjustTimezone() {
        return this.adjustTimezone;
    }

    public void setAdjustTimezone(boolean adjustTimezone) {
        this.adjustTimezone = adjustTimezone;
    }

    public String getLogTimezone() {
        return this.logTimezone;
    }

    public void setLogTimezone(String logTimezone) {
        this.logTimezone = logTimezone;
    }

    public long getDelayAlarmBytes() {
        return this.delayAlarmBytes;
    }

    public void setDelayAlarmBytes(long delayAlarmBytes) {
        this.delayAlarmBytes = delayAlarmBytes;
    }

    public String getMergeType() {
        return this.mergeType;
    }

    public void setMergeType(String mergeType) {
        this.mergeType = mergeType;
    }

    public int getMaxSendRate() {
        return this.maxSendRate;
    }

    public void setMaxSendRate(int maxSendRate) {
        this.maxSendRate = maxSendRate;
    }

    public int getSendRateExpire() {
        return this.sendRateExpire;
    }

    public void setSendRateExpire(int sendRateExpire) {
        this.sendRateExpire = sendRateExpire;
    }

    public boolean GetEnableRawLog() {
        return this.enableRawLog;
    }

    public void SetEnableRawLog(boolean enableRawLog) {
        this.enableRawLog = enableRawLog;
    }

    public boolean GetEnableTag() {
        return this.enableTag;
    }

    public void SetEnableTag(boolean enableTag) {
        this.enableTag = enableTag;
    }

    public boolean GetLocalStorage() {
        return this.localStorage;
    }

    public void SetLocalStorage(boolean localStorage) {
        this.localStorage = localStorage;
    }

    public void SetSensitiveKeys(List<SensitiveKey> sensitiveKeys) {
        this.sensitiveKeys = new ArrayList<SensitiveKey>(sensitiveKeys);
    }

    public ArrayList<SensitiveKey> GetSensitiveKeys() {
        return this.sensitiveKeys;
    }

    public void SetFilterKeyRegex(List<String> filterKey, List<String> filterRegex) {
        this.filterKey = new ArrayList<String>(filterKey);
        this.filterRegex = new ArrayList<String>(filterRegex);
    }

    public ArrayList<String> GetShardHashKey() {
        return this.shardHashKey;
    }

    public void SetShardHashKeyList(List<String> shardHashKey) {
        this.shardHashKey = new ArrayList<String>(shardHashKey);
    }

    public void SetShardHashKey(JSONArray shardHashKey) throws LogException {
        try {
            this.shardHashKey = new ArrayList();
            for (int i = 0; i < shardHashKey.size(); ++i) {
                this.shardHashKey.add(shardHashKey.getString(i));
            }
        }
        catch (JSONException e) {
            throw new LogException("FailToSetShardHashKey", e.getMessage(), e, "");
        }
    }

    public ArrayList<String> GetFilterRegex() {
        return this.filterRegex;
    }

    public void SetFilterRegex(JSONArray filterRegex) throws LogException {
        try {
            this.filterRegex = new ArrayList();
            for (int i = 0; i < filterRegex.size(); ++i) {
                this.filterRegex.add(filterRegex.getString(i));
            }
        }
        catch (JSONException e) {
            throw new LogException("FailToSetFilterRegex", e.getMessage(), e, "");
        }
    }

    public ArrayList<String> GetFilterKey() {
        return this.filterKey;
    }

    public void SetFilterKey(JSONArray filterKey) throws LogException {
        try {
            this.filterKey = new ArrayList();
            for (int i = 0; i < filterKey.size(); ++i) {
                this.filterKey.add(filterKey.getString(i));
            }
        }
        catch (JSONException e) {
            throw new LogException("FailToSetFilterKey", e.getMessage(), e, "");
        }
    }

    public abstract JSONObject ToJsonObject();

    public abstract void FromJsonObject(JSONObject var1) throws LogException;

    protected void CommonConfigToJsonObject(JSONObject jsonObj2) {
        jsonObj2.put("localStorage", (Object)this.localStorage);
        jsonObj2.put("enableTag", (Object)this.enableTag);
        jsonObj2.put("enableRawLog", (Object)this.enableRawLog);
        jsonObj2.put("maxSendRate", (Object)this.maxSendRate);
        jsonObj2.put("sendRateExpire", (Object)this.sendRateExpire);
        jsonObj2.put("mergeType", this.mergeType);
        jsonObj2.put("delayAlarmBytes", (Object)this.delayAlarmBytes);
        jsonObj2.put("adjustTimezone", (Object)this.adjustTimezone);
        jsonObj2.put("logTimezone", this.logTimezone);
        jsonObj2.put("priority", (Object)this.priority);
        JSONArray sensitiveKeysArray = new JSONArray();
        for (SensitiveKey sensitiveKey : this.sensitiveKeys) {
            sensitiveKeysArray.add(sensitiveKey.ToJsonObject());
        }
        jsonObj2.put("sensitive_keys", sensitiveKeysArray);
        JSONArray filterRegexArray = new JSONArray();
        for (String string2 : this.filterRegex) {
            filterRegexArray.add(string2);
        }
        jsonObj2.put("filterRegex", filterRegexArray);
        JSONArray jSONArray = new JSONArray();
        for (String fk : this.filterKey) {
            jSONArray.add(fk);
        }
        jsonObj2.put("filterKey", jSONArray);
        JSONArray jSONArray2 = new JSONArray();
        for (String shk : this.shardHashKey) {
            jSONArray2.add(shk);
        }
        jsonObj2.put("shardHashKey", jSONArray2);
    }

    protected void CommonConfigFromJsonObject(JSONObject inputDetail) throws LogException {
        try {
            this.adjustTimezone = inputDetail.has("adjustTimezone") ? inputDetail.getBoolean("adjustTimezone") : false;
            this.logTimezone = inputDetail.has("logTimezone") ? inputDetail.getString("logTimezone") : "";
            this.priority = inputDetail.has("priority") ? inputDetail.getInt("priority") : 0;
            this.mergeType = inputDetail.has("mergeType") ? inputDetail.getString("mergeType") : "topic";
            this.sendRateExpire = inputDetail.has("sendRateExpire") ? inputDetail.getInt("sendRateExpire") : 0;
            this.maxSendRate = inputDetail.has("maxSendRate") ? inputDetail.getInt("maxSendRate") : -1;
            this.localStorage = inputDetail.has("localStorage") ? inputDetail.getBoolean("localStorage") : true;
            this.enableTag = inputDetail.has("enableTag") ? inputDetail.getBoolean("enableTag") : false;
            this.enableRawLog = inputDetail.has("enableRawLog") ? inputDetail.getBoolean("enableRawLog") : false;
            this.delayAlarmBytes = inputDetail.has("delayAlarmBytes") ? inputDetail.getLong("delayAlarmBytes") : 0L;
            if (inputDetail.has("filterRegex")) {
                this.SetFilterRegex(inputDetail.getJSONArray("filterRegex"));
            }
            if (inputDetail.has("filterKey")) {
                this.SetFilterKey(inputDetail.getJSONArray("filterKey"));
            }
            if (inputDetail.has("shardHashKey")) {
                this.SetShardHashKey(inputDetail.getJSONArray("shardHashKey"));
            }
            if (inputDetail.has("sensitive_keys")) {
                JSONArray sensitiveKeysArray = inputDetail.getJSONArray("sensitive_keys");
                SensitiveKey sensitiveKey = new SensitiveKey();
                for (int index2 = 0; index2 < sensitiveKeysArray.size(); ++index2) {
                    sensitiveKey.FromJsonString(sensitiveKeysArray.getJSONObject(index2).toString());
                    this.sensitiveKeys.add(sensitiveKey);
                }
            }
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateInputDetail", e.getMessage(), e, "");
        }
    }

    public static CommonConfigInputDetail FromJsonStringS(String inputType, String jsonString) throws LogException {
        try {
            JSONObject inputDetail = JSONObject.fromObject(jsonString);
            return CommonConfigInputDetail.FromJsonObjectS(inputType, inputDetail);
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateInputDetail", e.getMessage(), e, "");
        }
    }

    public static CommonConfigInputDetail FromJsonObjectS(String inputType, JSONObject inputDetail) throws LogException {
        try {
            if (inputType.equals("syslog") || inputType.equals("streamlog")) {
                StreamLogConfigInputDetail res = new StreamLogConfigInputDetail();
                res.FromJsonObject(inputDetail);
                return res;
            }
            if (inputType.equals("plugin")) {
                PluginLogConfigInputDetail res = new PluginLogConfigInputDetail();
                res.FromJsonObject(inputDetail);
                return res;
            }
            if (inputType.equals("file")) {
                if (inputDetail.containsKey("logType")) {
                    if (inputDetail.getString("logType").compareTo("json_log") == 0) {
                        JsonConfigInputDetail res = new JsonConfigInputDetail();
                        res.FromJsonObject(inputDetail);
                        return res;
                    }
                    if (inputDetail.getString("logType").compareTo("delimiter_log") == 0) {
                        DelimiterConfigInputDetail res = new DelimiterConfigInputDetail();
                        res.FromJsonObject(inputDetail);
                        return res;
                    }
                    if (inputDetail.getString("logType").compareTo("apsara_log") == 0) {
                        ApsaraLogConfigInputDetail res = new ApsaraLogConfigInputDetail();
                        res.FromJsonObject(inputDetail);
                        return res;
                    }
                    if (inputDetail.getString("logType").compareTo("common_reg_log") == 0) {
                        ConfigInputDetail res = new ConfigInputDetail();
                        res.FromJsonObject(inputDetail);
                        return res;
                    }
                    throw new LogException("FailToGenerateInputDetail", "invlaid logType", inputDetail.getString("logType"));
                }
                throw new LogException("FailToGenerateInputDetail", "logType field does not exist in input detail", "");
            }
            throw new LogException("FailToGenerateInputDetail", "invalid inputType", inputType);
        }
        catch (JSONException e) {
            throw new LogException("FailToGenerateInputDetail", e.getMessage(), e, "");
        }
    }
}

