/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common;

import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.DashboardBasedJobConfiguration;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.DingTalkNotification;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.EmailNotification;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.MessageCenterNotification;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.Notification;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.NotificationType;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.Query;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.SmsNotification;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.VoiceNotification;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.common.WebhookNotification;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.internal.Unmarshaller;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.util.Args;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.util.JsonUtils;
import com.alibaba.schedulerx.shade.com.aliyun.openservices.log.util.Utils;
import com.alibaba.schedulerx.shade.net.sf.json.JSONArray;
import com.alibaba.schedulerx.shade.net.sf.json.JSONObject;
import java.util.Date;
import java.util.List;

public class AlertConfiguration
extends DashboardBasedJobConfiguration {
    @JSONField
    private String condition;
    @JSONField
    private List<Query> queryList;
    @JSONField
    private Date muteUntil;
    @JSONField
    private Integer notifyThreshold = 1;
    @JSONField
    private String throttling;

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public List<Query> getQueryList() {
        return this.queryList;
    }

    public void setQueryList(List<Query> queryList) {
        this.queryList = queryList;
    }

    public Date getMuteUntil() {
        return this.muteUntil;
    }

    public void setMuteUntil(Date muteUntil) {
        this.muteUntil = muteUntil;
    }

    public Integer getNotifyThreshold() {
        return this.notifyThreshold;
    }

    public void setNotifyThreshold(Integer notifyThreshold) {
        this.notifyThreshold = notifyThreshold;
    }

    public String getThrottling() {
        return this.throttling;
    }

    public void setThrottling(String throttling) {
        Args.checkDuration(throttling);
        this.throttling = throttling;
    }

    @Override
    public void deserialize(JSONObject value2) {
        super.deserialize(value2);
        this.condition = value2.getString("condition");
        this.queryList = JsonUtils.readList(value2, "queryList", new Unmarshaller<Query>(){

            @Override
            public Query unmarshal(JSONArray value2, int index2) {
                Query query = new Query();
                query.deserialize(value2.getJSONObject(index2));
                return query;
            }
        });
        if (value2.has("muteUntil")) {
            this.muteUntil = Utils.timestampToDate(value2.getLong("muteUntil"));
        }
        this.notifyThreshold = JsonUtils.readOptionalInt(value2, "notifyThreshold");
        this.throttling = JsonUtils.readOptionalString(value2, "throttling");
    }

    @Override
    Notification makeQualifiedNotification(NotificationType type) {
        switch (type) {
            case DING_TALK: {
                return new DingTalkNotification();
            }
            case EMAIL: {
                return new EmailNotification();
            }
            case MESSAGE_CENTER: {
                return new MessageCenterNotification();
            }
            case SMS: {
                return new SmsNotification();
            }
            case WEBHOOK: {
                return new WebhookNotification();
            }
            case VOICE: {
                return new VoiceNotification();
            }
        }
        throw new IllegalArgumentException("Unimplemented notification type: " + (Object)((Object)type));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlertConfiguration that = (AlertConfiguration)o;
        if (this.getCondition() != null ? !this.getCondition().equals(that.getCondition()) : that.getCondition() != null) {
            return false;
        }
        if (this.getQueryList() != null ? !this.getQueryList().equals(that.getQueryList()) : that.getQueryList() != null) {
            return false;
        }
        if (this.getMuteUntil() != null ? !this.getMuteUntil().equals(that.getMuteUntil()) : that.getMuteUntil() != null) {
            return false;
        }
        if (this.getNotifyThreshold() != null ? !this.getNotifyThreshold().equals(that.getNotifyThreshold()) : that.getNotifyThreshold() != null) {
            return false;
        }
        return this.getThrottling() != null ? this.getThrottling().equals(that.getThrottling()) : that.getThrottling() == null;
    }

    public int hashCode() {
        int result2 = this.getCondition() != null ? this.getCondition().hashCode() : 0;
        result2 = 31 * result2 + (this.getQueryList() != null ? this.getQueryList().hashCode() : 0);
        result2 = 31 * result2 + (this.getMuteUntil() != null ? this.getMuteUntil().hashCode() : 0);
        result2 = 31 * result2 + (this.getNotifyThreshold() != null ? this.getNotifyThreshold().hashCode() : 0);
        result2 = 31 * result2 + (this.getThrottling() != null ? this.getThrottling().hashCode() : 0);
        return result2;
    }
}

