/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.sdk;

import com.alibaba.schedulerx.common.exception.RequestCheckException;
import com.alibaba.schedulerx.common.sdk.common.ParamValidate;
import com.alibaba.schedulerx.common.sdk.common.SchedulerXResult;
import com.alibaba.schedulerx.common.sdk.request.BaseRequest;
import com.alibaba.schedulerx.common.sdk.response.BaseResponse;
import com.alibaba.schedulerx.common.util.SignatureUtil;
import com.alibaba.schedulerx.sdk.http.HttpClientUtil;
import com.alibaba.schedulerx.shade.org.apache.commons.lang.StringUtils;
import com.alibaba.schedulerx.worker.log.LogFactory;
import com.alibaba.schedulerx.worker.log.Logger;
import java.util.HashMap;
import java.util.Map;

public class OpenApiClient {
    private static final Logger logger = LogFactory.getLogger("openapi");
    private String appKey;
    private String groupId;
    private String domain;
    private String user;
    private String namespace;
    private String namespaceSource;
    private boolean isCreateGroup = false;

    public OpenApiClient(String appKey, String groupId, String domain) {
        this.appKey = appKey;
        this.groupId = groupId;
        this.domain = domain.contains("http") ? domain : "http://" + domain;
    }

    public OpenApiClient(String appKey, String groupId, String domain, String user) {
        this(appKey, groupId, domain);
        this.user = user;
    }

    public OpenApiClient(String domain, String user) {
        this.domain = domain;
        this.user = user;
        this.isCreateGroup = true;
        this.domain = domain.contains("http") ? domain : "http://" + domain;
    }

    public <T extends BaseResponse> SchedulerXResult<T> getResponse(BaseRequest<T> request2) throws Exception {
        if (this.groupId != null) {
            request2.setGroupId(this.getGroupId());
        }
        request2.getParameterMap().put("user", StringUtils.isBlank(this.user) ? "openapi" : this.user);
        this.validateCommonParam();
        Map<String, String> headers = this.genHeaders();
        ParamValidate.doValidator(request2);
        request2.preRun();
        logger.info("getResponse url: {} request params : {}", request2.getUrlPath(), request2.getParameterMap().toString());
        return HttpClientUtil.getResponse(request2, this.getDomain(), headers);
    }

    private Map<String, String> genHeaders() throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (StringUtils.isNotBlank(this.namespace)) {
            headers.put("schedulerx-namespace", this.namespace);
            if (StringUtils.isNotBlank(this.namespaceSource)) {
                headers.put("schedulerx-namespace-source", this.namespaceSource);
            }
        }
        String timeNow = Long.toString(System.currentTimeMillis());
        headers.put("openapi-timestamp", timeNow);
        if (this.groupId != null && this.appKey != null) {
            headers.put("openapi-signature", SignatureUtil.geneHmacSHA1Encrypt(timeNow, this.groupId, this.appKey));
        }
        headers.put("openapi-groupid", this.groupId);
        headers.put("openapi-create-group", String.valueOf(this.isCreateGroup));
        return headers;
    }

    private void validateCommonParam() {
        if (StringUtils.isBlank(this.domain)) {
            throw new RequestCheckException(-10000, "domain can not be blank");
        }
    }

    public String getAppKey() {
        return this.appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getNamespaceSource() {
        return this.namespaceSource;
    }

    public void setNamespaceSource(String namespaceSource) {
        this.namespaceSource = namespaceSource;
    }
}

