/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.common.util;

public class StringUtils {
    private static final int PAD_LIMIT = 8192;

    public static String leftPad(String str, int size2, String padStr) {
        if (str == null) {
            return null;
        }
        if (StringUtils.isEmpty(padStr)) {
            padStr = " ";
        }
        int padLen = padStr.length();
        int strLen = str.length();
        int pads = size2 - strLen;
        if (pads <= 0) {
            return str;
        }
        if (padLen == 1 && pads <= 8192) {
            return StringUtils.leftPad(str, size2, padStr.charAt(0));
        }
        if (pads == padLen) {
            return padStr.concat(str);
        }
        if (pads < padLen) {
            return padStr.substring(0, pads).concat(str);
        }
        char[] padding2 = new char[pads];
        char[] padChars = padStr.toCharArray();
        for (int i = 0; i < pads; ++i) {
            padding2[i] = padChars[i % padLen];
        }
        return new String(padding2).concat(str);
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtils.isEmpty(str);
    }

    public static String leftPad(String str, int size2, char padChar) {
        if (str == null) {
            return null;
        }
        int pads = size2 - str.length();
        if (pads <= 0) {
            return str;
        }
        if (pads > 8192) {
            return StringUtils.leftPad(str, size2, String.valueOf(padChar));
        }
        return StringUtils.padding(pads, padChar).concat(str);
    }

    private static String padding(int repeat2, char padChar) throws IndexOutOfBoundsException {
        if (repeat2 < 0) {
            throw new IndexOutOfBoundsException("Cannot pad a negative amount: " + repeat2);
        }
        char[] buf = new char[repeat2];
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = padChar;
        }
        return new String(buf);
    }
}

