/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.schedulerx.common.util;

import com.alibaba.schedulerx.common.util.StringUtils;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;

public class IpUtil {
    public static String getFormatIpv4Address() {
        String[] ipTokens;
        String ipv4 = IpUtil.getIPV4Address();
        if (ipv4 == null) {
            return String.valueOf(System.currentTimeMillis());
        }
        StringBuilder ipv4Builder = new StringBuilder();
        for (String token2 : ipTokens = ipv4.split("\\.")) {
            ipv4Builder.append(StringUtils.leftPad(token2, 3, "0"));
        }
        return ipv4Builder.toString();
    }

    public static String getIPV4Address() {
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            ArrayList<String> ipv4Result = new ArrayList<String>();
            ArrayList<String> ipv6Result = new ArrayList<String>();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> en = networkInterface.getInetAddresses();
                while (en.hasMoreElements()) {
                    InetAddress address = en.nextElement();
                    if (address.isLoopbackAddress()) continue;
                    if (address instanceof Inet6Address) {
                        ipv6Result.add(IpUtil.normalizeHostAddress(address));
                        continue;
                    }
                    ipv4Result.add(IpUtil.normalizeHostAddress(address));
                }
            }
            if (!ipv4Result.isEmpty()) {
                for (String ip : ipv4Result) {
                    if (ip.startsWith("127.0") || ip.startsWith("192.168")) continue;
                    return ip;
                }
                return (String)ipv4Result.get(0);
            }
            if (!ipv6Result.isEmpty()) {
                return (String)ipv6Result.get(0);
            }
            InetAddress localHost = InetAddress.getLocalHost();
            return IpUtil.normalizeHostAddress(localHost);
        }
        catch (SocketException | UnknownHostException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String normalizeHostAddress(InetAddress localHost) {
        if (localHost instanceof Inet6Address) {
            return "[" + localHost.getHostAddress() + "]";
        }
        return localHost.getHostAddress();
    }

    public static void main(String[] args) {
        System.out.println(IpUtil.getIPV4Address());
        System.out.println(IpUtil.getFormatIpv4Address());
    }
}

