/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.impl;

import akka.stream.impl.ReactiveStreamsCompliance;
import akka.stream.impl.ReactiveStreamsCompliance$;
import akka.stream.impl.ResizableMultiReaderRingBuffer;
import akka.stream.impl.SubscriberManagement;
import akka.stream.impl.SubscriberManagement$;
import akka.stream.impl.SubscriberManagement$Completed$;
import akka.stream.impl.SubscriberManagement$NotReached$;
import akka.stream.impl.SubscriptionWithCursor;
import org.reactivestreams.Subscriber;
import scala.MatchError;
import scala.Serializable;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.math.package$;
import scala.runtime.BoxedUnit;

public abstract class SubscriberManagement$class {
    public static String bufferDebug(SubscriberManagement $this) {
        return $this.akka$stream$impl$SubscriberManagement$$buffer().toString();
    }

    public static List cursors(SubscriberManagement $this) {
        return $this.akka$stream$impl$SubscriberManagement$$subscriptions();
    }

    public static void moreRequested(SubscriberManagement $this, SubscriptionWithCursor subscription, long elements) {
        if (subscription.active()) {
            if (elements < 1L) {
                ReactiveStreamsCompliance$.MODULE$.tryOnError(subscription.subscriber(), ReactiveStreamsCompliance$.MODULE$.numberOfElementsInRequestMustBePositiveException());
            } else {
                SubscriberManagement.EndOfStream endOfStream = $this.akka$stream$impl$SubscriberManagement$$endOfStream();
                boolean bl = SubscriberManagement$NotReached$.MODULE$.equals(endOfStream) ? true : SubscriberManagement$Completed$.MODULE$.equals(endOfStream);
                if (bl) {
                    long d = subscription.totalDemand() + elements;
                    long demand = d < 1L ? Long.MAX_VALUE : d;
                    subscription.totalDemand_$eq(demand);
                    long l = SubscriberManagement$class.dispatchFromBufferAndReturnRemainingRequested$1($this, demand, endOfStream, subscription);
                    if (Long.MIN_VALUE == l) {
                        endOfStream.apply(subscription.subscriber());
                        SubscriberManagement$class.unregisterSubscriptionInternal($this, subscription);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        subscription.totalDemand_$eq(l);
                        SubscriberManagement$class.akka$stream$impl$SubscriberManagement$$requestFromUpstreamIfRequired($this);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (endOfStream instanceof SubscriberManagement.ErrorCompleted) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError(endOfStream);
                }
            }
        }
        return;
        finally {
            SubscriberManagement$class.unregisterSubscriptionInternal($this, subscription);
        }
    }

    public static final void akka$stream$impl$SubscriberManagement$$requestFromUpstreamIfRequired(SubscriberManagement $this) {
        int desired = (int)Math.min(Integer.MAX_VALUE, Math.min(SubscriberManagement$class.maxRequested$1($this, $this.akka$stream$impl$SubscriberManagement$$subscriptions(), SubscriberManagement$class.maxRequested$default$2$1($this)), (long)$this.akka$stream$impl$SubscriberManagement$$buffer().maxAvailable()) - $this.akka$stream$impl$SubscriberManagement$$pendingFromUpstream());
        if (desired > 0) {
            $this.akka$stream$impl$SubscriberManagement$$pendingFromUpstream_$eq($this.akka$stream$impl$SubscriberManagement$$pendingFromUpstream() + (long)desired);
            $this.requestFromUpstream(desired);
        }
    }

    public static void pushToDownstream(SubscriberManagement $this, Object value2) {
        SubscriberManagement.EndOfStream endOfStream = $this.akka$stream$impl$SubscriberManagement$$endOfStream();
        if (SubscriberManagement$NotReached$.MODULE$.equals(endOfStream)) {
            $this.akka$stream$impl$SubscriberManagement$$pendingFromUpstream_$eq($this.akka$stream$impl$SubscriberManagement$$pendingFromUpstream() - 1L);
            if ($this.akka$stream$impl$SubscriberManagement$$buffer().write(value2)) {
                BoxedUnit boxedUnit;
                if (SubscriberManagement$class.dispatch$1($this, $this.akka$stream$impl$SubscriberManagement$$subscriptions(), SubscriberManagement$class.dispatch$default$2$1($this))) {
                    SubscriberManagement$class.akka$stream$impl$SubscriberManagement$$requestFromUpstreamIfRequired($this);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
                return;
            }
            throw new IllegalStateException("Output buffer overflow");
        }
        throw new IllegalStateException("pushToDownStream(...) after completeDownstream() or abortDownstream(...)");
    }

    public static void completeDownstream(SubscriberManagement $this) {
        if ($this.akka$stream$impl$SubscriberManagement$$endOfStream() == SubscriberManagement$NotReached$.MODULE$) {
            $this.akka$stream$impl$SubscriberManagement$$endOfStream_$eq(SubscriberManagement$Completed$.MODULE$);
            $this.akka$stream$impl$SubscriberManagement$$subscriptions_$eq(SubscriberManagement$class.completeDoneSubscriptions$1($this, $this.akka$stream$impl$SubscriberManagement$$subscriptions(), SubscriberManagement$class.completeDoneSubscriptions$default$2$1($this)));
            if ($this.akka$stream$impl$SubscriberManagement$$subscriptions().isEmpty()) {
                $this.shutdown(true);
            }
        }
    }

    public static void abortDownstream(SubscriberManagement $this, Throwable cause) {
        $this.akka$stream$impl$SubscriberManagement$$endOfStream_$eq(new SubscriberManagement.ErrorCompleted(cause));
        $this.akka$stream$impl$SubscriberManagement$$subscriptions().foreach(new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SubscriberManagement $outer;

            public final void apply(SubscriptionWithCursor s2) {
                this.$outer.akka$stream$impl$SubscriberManagement$$endOfStream().apply(s2.subscriber());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        $this.akka$stream$impl$SubscriberManagement$$subscriptions_$eq(Nil$.MODULE$);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void registerSubscriber(SubscriberManagement $this, Subscriber subscriber) {
        boolean bl = false;
        SubscriberManagement.EndOfStream endOfStream = null;
        SubscriberManagement.EndOfStream endOfStream2 = $this.akka$stream$impl$SubscriberManagement$$endOfStream();
        if (SubscriberManagement$NotReached$.MODULE$.equals(endOfStream2)) {
            bl = true;
            endOfStream = endOfStream2;
            if ($this.akka$stream$impl$SubscriberManagement$$subscriptions().exists(new Serializable($this, subscriber){
                public static final long serialVersionUID = 0L;
                private final Subscriber subscriber$1;

                public final boolean apply(SubscriptionWithCursor x$2) {
                    Subscriber<T> subscriber = x$2.subscriber();
                    Subscriber subscriber2 = this.subscriber$1;
                    return !(subscriber != null ? !subscriber.equals((Object)subscriber2) : subscriber2 != null);
                }
                {
                    this.subscriber$1 = subscriber$1;
                }
            })) {
                ReactiveStreamsCompliance$.MODULE$.rejectDuplicateSubscriber(subscriber);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (bl) {
            SubscriberManagement$class.addSubscription($this, subscriber);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (SubscriberManagement$Completed$.MODULE$.equals(endOfStream2) && $this.akka$stream$impl$SubscriberManagement$$buffer().nonEmpty()) {
            SubscriberManagement$class.addSubscription($this, subscriber);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        endOfStream2.apply(subscriber);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private static void addSubscription(SubscriberManagement $this, Subscriber subscriber) {
        Throwable throwable2;
        block2: {
            SubscriptionWithCursor newSubscription = $this.createSubscription(subscriber);
            $this.akka$stream$impl$SubscriberManagement$$subscriptions_$eq($this.akka$stream$impl$SubscriberManagement$$subscriptions().$colon$colon(newSubscription));
            $this.akka$stream$impl$SubscriberManagement$$buffer().initCursor(newSubscription);
            try {
                ReactiveStreamsCompliance$.MODULE$.tryOnSubscribe(subscriber, newSubscription);
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                if (!(throwable3 instanceof ReactiveStreamsCompliance.SpecViolation)) break block2;
                SubscriberManagement$class.unregisterSubscriptionInternal($this, newSubscription);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw throwable2;
    }

    public static void unregisterSubscription(SubscriberManagement $this, SubscriptionWithCursor subscription) {
        SubscriberManagement$class.unregisterSubscriptionInternal($this, subscription);
    }

    private static void unregisterSubscriptionInternal(SubscriberManagement $this, SubscriptionWithCursor subscription) {
        if (subscription.active()) {
            $this.akka$stream$impl$SubscriberManagement$$subscriptions_$eq(SubscriberManagement$class.removeFrom$1($this, $this.akka$stream$impl$SubscriberManagement$$subscriptions(), SubscriberManagement$class.removeFrom$default$2$1($this), subscription));
            $this.akka$stream$impl$SubscriberManagement$$buffer().onCursorRemoved(subscription);
            subscription.active_$eq(false);
            if ($this.akka$stream$impl$SubscriberManagement$$subscriptions().isEmpty()) {
                if ($this.akka$stream$impl$SubscriberManagement$$endOfStream() == SubscriberManagement$NotReached$.MODULE$) {
                    $this.akka$stream$impl$SubscriberManagement$$endOfStream_$eq(SubscriberManagement$.MODULE$.ShutDown());
                    $this.cancelUpstream();
                }
                $this.shutdown(false);
            } else {
                SubscriberManagement$class.akka$stream$impl$SubscriberManagement$$requestFromUpstreamIfRequired($this);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final long dispatchFromBufferAndReturnRemainingRequested$1(SubscriberManagement $this, long requested, SubscriberManagement.EndOfStream eos, SubscriptionWithCursor subscription$2) {
        while (true) {
            boolean goOn;
            boolean bl;
            if (requested != 0L) {
                if ($this.akka$stream$impl$SubscriberManagement$$buffer().count(subscription$2) <= 0) break;
            } else {
                if (eos == SubscriberManagement$NotReached$.MODULE$) return 0L;
                if ($this.akka$stream$impl$SubscriberManagement$$buffer().count(subscription$2) != 0) return 0L;
                return Long.MIN_VALUE;
            }
            try {
                subscription$2.dispatch($this.akka$stream$impl$SubscriberManagement$$buffer().read(subscription$2));
                bl = true;
            }
            catch (Throwable throwable) {
                boolean bl2;
                Throwable throwable2 = throwable;
                if (!(throwable2 instanceof ReactiveStreamsCompliance.SpecViolation)) throw throwable;
                SubscriberManagement$class.unregisterSubscriptionInternal($this, subscription$2);
                bl = bl2 = false;
            }
            if (!(goOn = bl)) return Long.MIN_VALUE;
            --requested;
        }
        if (eos != SubscriberManagement$NotReached$.MODULE$) {
            return Long.MIN_VALUE;
        }
        long l = requested;
        return l;
    }

    private static final long maxRequested$1(SubscriberManagement $this, List remaining, long result2) {
        List list;
        while ((list = remaining) instanceof $colon$colon) {
            $colon$colon $colon$colon = ($colon$colon)list;
            SubscriptionWithCursor head2 = (SubscriptionWithCursor)$colon$colon.head();
            List tail = $colon$colon.tl$1();
            result2 = package$.MODULE$.max(head2.totalDemand(), result2);
            remaining = tail;
        }
        long l = result2;
        return l;
    }

    private static final long maxRequested$default$2$1(SubscriberManagement $this) {
        return 0L;
    }

    private static final boolean dispatch$1(SubscriberManagement $this, List remaining, boolean sent) {
        List list;
        while ((list = remaining) instanceof $colon$colon) {
            $colon$colon $colon$colon = ($colon$colon)list;
            SubscriptionWithCursor head2 = (SubscriptionWithCursor)$colon$colon.head();
            List tail = $colon$colon.tl$1();
            if (head2.totalDemand() > 0L) {
                Object element = $this.akka$stream$impl$SubscriberManagement$$buffer().read(head2);
                head2.dispatch(element);
                head2.totalDemand_$eq(head2.totalDemand() - 1L);
                sent = true;
                remaining = tail;
                continue;
            }
            remaining = tail;
        }
        boolean bl = sent;
        return bl;
    }

    private static final boolean dispatch$default$2$1(SubscriberManagement $this) {
        return false;
    }

    private static final List completeDoneSubscriptions$1(SubscriberManagement $this, List remaining, List result2) {
        List list;
        while ((list = remaining) instanceof $colon$colon) {
            $colon$colon $colon$colon = ($colon$colon)list;
            SubscriptionWithCursor head2 = (SubscriptionWithCursor)$colon$colon.head();
            List tail = $colon$colon.tl$1();
            if ($this.akka$stream$impl$SubscriberManagement$$buffer().count(head2) == 0) {
                head2.active_$eq(false);
                SubscriberManagement$Completed$.MODULE$.apply(head2.subscriber());
                remaining = tail;
                continue;
            }
            SubscriptionWithCursor subscriptionWithCursor = head2;
            result2 = result2.$colon$colon(subscriptionWithCursor);
            remaining = tail;
        }
        List<SubscriptionWithCursor> list2 = result2;
        return list2;
    }

    private static final List completeDoneSubscriptions$default$2$1(SubscriberManagement $this) {
        return Nil$.MODULE$;
    }

    private static final List removeFrom$1(SubscriberManagement $this, List remaining, List result2, SubscriptionWithCursor subscription$1) {
        List list;
        while ((list = remaining) instanceof $colon$colon) {
            $colon$colon $colon$colon = ($colon$colon)list;
            SubscriptionWithCursor head2 = (SubscriptionWithCursor)$colon$colon.head();
            List tail = $colon$colon.tl$1();
            if (head2 == subscription$1) {
                List list2 = tail;
                List list3 = result2.reverse_$colon$colon$colon(list2);
                return list3;
            }
            SubscriptionWithCursor subscriptionWithCursor = head2;
            result2 = result2.$colon$colon(subscriptionWithCursor);
            remaining = tail;
        }
        throw new IllegalStateException("Subscription to unregister not found");
    }

    private static final List removeFrom$default$2$1(SubscriberManagement $this) {
        return Nil$.MODULE$;
    }

    public static void $init$(SubscriberManagement $this) {
        $this.akka$stream$impl$SubscriberManagement$_setter_$akka$stream$impl$SubscriberManagement$$buffer_$eq(new ResizableMultiReaderRingBuffer($this.initialBufferSize(), $this.maxBufferSize(), $this));
        $this.akka$stream$impl$SubscriberManagement$$subscriptions_$eq(Nil$.MODULE$);
        $this.akka$stream$impl$SubscriberManagement$$pendingFromUpstream_$eq(0L);
        $this.akka$stream$impl$SubscriberManagement$$endOfStream_$eq(SubscriberManagement$NotReached$.MODULE$);
    }
}

